<?php

namespace Modules\Verification\app\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\View\View;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Verification;
use Illuminate\Support\Str;
use Intervention\Image\ImageManager;
// use Intervention\Image\Drivers\Gd\Driver as GdDriver;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Intervention\Image\Drivers\Gd\Driver;

class VerificationController extends Controller
{
    /**
     * Display a listing of the resource.
     */
function index(Request $request) {
        // return true;
        $query = Verification::query();
        $query->when($request->keyword, fn($q) => $q->where('student_name', 'like', '%' . request('keyword') . '%'));
        $query->when($request->date && $request->filled('date'), fn($q) => $q->whereDate('created_at', $request->date));
        // $query->when($request->approve_status && $request->filled('approve_status'), fn($q) => $q->where('is_approved', $request->approve_status));
        $query->when($request->status && $request->filled('status'), fn($q) => $q->where('status', $request->status));
        $orderBy = $request->order_by == 1 ? 'asc' : 'desc';
        $verifications = $request->par_page == 'all' ?
        $query->orderBy('id', $orderBy)->get() :
        $query->orderBy('id', $orderBy)->paginate($request->par_page ?? null)->withQueryString();
        // $instructors = User::where('role', 'instructor')->get();
        return view('verification::verification.index', compact('verifications'));
    }

    /**
     * Show the form for creating a new resource.
     */
    function editView(string $id) {
        Session::put('verificaion_create', $id);
        $verification = Verification::findOrFail($id);
        $editMode = true;
        return view('verification::verification.create', compact('verification', 'editMode'));
    }
    function create() {
        // $instructors = User::where('role', 'instructor')->get();
        return view('verification::verification.create');
    }

    function getQR(string $id){
    $verification = Verification::findOrFail($id);
    
    // Generate QR code with merged logo
    $data = QrCode::size(900)
    ->format('png')
    ->merge(public_path('uploads/website-images/qr-image.png'), .2, true)
    ->errorCorrection('Q')
    ->generate('http://brightfuture.pk/verify/'.$verification->code);

    // Convert raw PNG to GD image
    $img = imagecreatefromstring($data);

    // Make white color transparent
    $white = imagecolorallocate($img, 255, 255, 255);
    imagecolortransparent($img, $white);

    // Capture output into buffer
    ob_start();
    imagepng($img); // write image data to buffer
    $imageData = ob_get_clean(); // get image data

    // Free memory
    imagedestroy($img);

    // Return as HTTP response
        return response($imageData)
        ->header('Content-Type', 'image/png')
        ->header('Content-Disposition', 'inline; filename="qrcode.png"');
    // return Response::make($imageData)->header('Content-Type', 'image/png');

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        if ($request->edit_mode == 1) {
            // return $request->id;
            $verification = Verification::findOrFail($request->id);
            // $course->instructor_id = $request->instructor;
        } else {
            $verification = new Verification();
            do {
            $code = Str::random(20);
            } while (Verification::where('code', $code)->exists());

            $verification->code = $code;
        }

        $verification->student_name = $request->student_name;
        $verification->father_name = $request->father_name;
        $verification->cnic_number = $request->cnic_number;
        $verification->date_of_birth = $request->date_of_birth;
        $verification->grade = $request->grade;
        $verification->percentage = $request->percentage;
        $verification->session = $request->session;
        $verification->college = $request->college;
        $verification->diploma_title = $request->diploma_title;
        $verification->diploma_tenure = $request->diploma_tenure;
        $verification->result_announcement_date = $request->result_announcement_date;
        $verification->registration_number = $request->registration_number;
        $verification->certificate_number = $request->certificate_number;
        $verification->status = $request->status;
        $verification->save();

        // save course id in session
        Session::put('verification_create', $verification->id);

        return response()->json([
            'status'   => 'success',
            'message'  => __('Updated successfully'),
            'redirect' => route('admin.verifications.edit', ['id' => $verification->id, 'step' => $request->next_step]),
        ]);
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('verification::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        if (!Session::get('verification_create')) {
            return redirect(route('admin.verifications.create'));
        }else{
            return redirect(route('admin.verifications.index'));
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id): RedirectResponse
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        return true;
    }
}
