@extends('admin.master_layout')
@section('title')
    <title>{{ __('Course Create') }}</title>
@endsection
@section('admin-content')
     <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary">{{ __('Certificate') }}</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                    </div>
                    <div class="breadcrumb-item">{{ __('Certificate') }}</div>
                </div>
            </div>
            <div class="section-body">
                <div class="dashboard__content-wrap">
                    <div class="row">
                        <div class="col-12">
                            {{-- @include('verfication::verfication.navigation') --}}

                            <div class="card">
                                <div class="card-body">
                                    <div class="instructor__profile-form-wrap mt-4">
                                        <form action="{{ route('admin.verfications.store', ['id' => @$verification->id]) }}"
                                            class="instructor__profile-form course-form">
                                            @csrf
                                            <input type="hidden" name="step" value="1">
                                            <input type="hidden" name="next_step" value="2">
                                            <input type="hidden" name="edit_mode"
                                                value="{{ isset($editMode) && $editMode == true ? true : false }}">

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="instructor">{{ __('Instructor') }}
                                                            <code>*</code></label>
                                                        <select name="instructor" id=""
                                                            class="form-control select2">
                                                            <option value="">{{ __('Select') }}</option>

                                                        </select>
                                                    </div>
                                                </div>

                                                {{-- Student Name --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="student_name">{{ __('Student Name') }} <code>*</code></label>
                <input id="student_name" name="student_name" type="text" class="form-control"
                       value="{{ old('student_name', @$verification?->student_name) }}">
            </div>
        </div>

        {{-- Father Name --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="father_name">{{ __('Father Name') }} <code>*</code></label>
                <input id="father_name" name="father_name" type="text" class="form-control"
                       value="{{ old('father_name', @$verification?->father_name) }}">
            </div>
        </div>

        {{-- CNIC Number --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="cnic_number">{{ __('CNIC Number') }} <code>*</code></label>
                <input id="cnic_number" name="cnic_number" type="text" class="form-control"
                       value="{{ old('cnic_number', @$verification?->cnic_number) }}">
            </div>
        </div>

        {{-- Date of Birth --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="date_of_birth">{{ __('Date of Birth') }} <code>*</code></label>
                <input id="date_of_birth" name="date_of_birth" type="date" class="form-control"
                       value="{{ old('date_of_birth', @$verification?->date_of_birth) }}">
            </div>
        </div>

        {{-- Grade --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="grade">{{ __('Grade') }} <code>*</code></label>
                <input id="grade" name="grade" type="text" class="form-control"
                       value="{{ old('grade', @$verification?->grade) }}">
            </div>
        </div>

        {{-- Percentage --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="percentage">{{ __('Percentage') }} <code>*</code></label>
                <input id="percentage" name="percentage" type="number" step="0.01" max="100" min="0"
                       class="form-control" value="{{ old('percentage', @$verification?->percentage) }}">
            </div>
        </div>

        {{-- Session --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="session">{{ __('Session') }} <code>*</code></label>
                <input id="session" name="session" type="text" class="form-control"
                       value="{{ old('session', @$verification?->session) }}">
            </div>
        </div>

        {{-- College --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="college">{{ __('College') }} <code>*</code></label>
                <input id="college" name="college" type="text" class="form-control"
                       value="{{ old('college', @$verification?->college) }}">
            </div>
        </div>

        {{-- Diploma Title --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="diploma_title">{{ __('Diploma Title') }} <code>*</code></label>
                <input id="diploma_title" name="diploma_title" type="text" class="form-control"
                       value="{{ old('diploma_title', @$verification?->diploma_title) }}">
            </div>
        </div>

        {{-- Diploma Tenure --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="diploma_tenure">{{ __('Diploma Tenure') }} <code>*</code></label>
                <input id="diploma_tenure" name="diploma_tenure" type="text" class="form-control"
                       value="{{ old('diploma_tenure', @$verification?->diploma_tenure) }}">
            </div>
        </div>

        {{-- Result Announcement Date --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="result_announcement_date">{{ __('Result Announcement Date') }} <code>*</code></label>
                <input id="result_announcement_date" name="result_announcement_date" type="date" class="form-control"
                       value="{{ old('result_announcement_date', @$verification?->result_announcement_date) }}">
            </div>
        </div>

        {{-- Registration Number --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="registration_number">{{ __('Registration Number') }} <code>*</code></label>
                <input id="registration_number" name="registration_number" type="text" class="form-control"
                       value="{{ old('registration_number', @$verification?->registration_number) }}">
            </div>
        </div>

        {{-- Certificate Number --}}
<div class="col-md-6">
    <div class="form-group">
        <label for="certificate_number">{{ __('Certificate Number') }} <code>*</code></label>
        <input id="certificate_number" name="certificate_number" type="text" class="form-control"
               value="{{ old('certificate_number', @$verification?->certificate_number) }}">
    </div>
</div>

        {{-- Status --}}
        <div class="col-md-6">
            <div class="form-group">
                <label for="status">{{ __('Status') }} <code>*</code></label>
                <select name="status" class="form-control">
                    <option value="active" @selected(@$verification?->status == 'active')>{{ __('Active') }}</option>
                    <option value="canceled" @selected(@$verification?->status == 'canceled')>{{ __('Canceled') }}</option>
                    <option value="expired" @selected(@$verification?->status == 'expired')>{{ __('Expired') }}</option>
                </select>
            </div>
        </div>
                                            </div>
                                            <button class="btn btn-primary" type="submit">{{ __('Save') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/js/default/courses.js') }}"></script>
@endpush

@push('css')
    <style>
        .dd-custom-css {
            position: absolute;
            will-change: transform;
            top: 0px;
            left: 0px;
            transform: translate3d(0px, -131px, 0px);
        }

        .max-h-400 {
            min-height: 400px;
        }
    </style>
@endpush