<?php

use Faker\Guesser\Name;
use Illuminate\Support\Facades\Route;
use Modules\Verification\app\Http\Controllers\VerificationController;

Route::group(['middleware' => ['auth:admin', 'translation'], 'prefix' => 'admin', 'as' => 'admin.'], function () {
    Route::resource('verification', VerificationController::class)->names('course');


    /** Course Routes */
    Route::get('verifications', [VerificationController::class, 'index'])->name('verifications.index');
    Route::get('verifications/{id}/edit', [VerificationController::class, 'editView'])->name('verifications.edit-view');

    Route::get('verifications/create', [VerificationController::class, 'create'])
    ->name('verification.create');
    Route::post('verifications/create', [VerificationController::class, 'store'])->name('verfications.store');
    Route::get('verifications/create/{id}/step/{step?}', [VerificationController::class, 'edit'])->name('verifications.edit');


// Destroy route
    Route::delete('verifications/{id}', [VerificationController::class, 'destroy'])
    ->name('verifications.destroy');
    Route::get('verifications/qrcode/{id}', [VerificationController::class, 'getQR'])
    ->name('verifications.qrcode');

    Route::delete('verifications/{id}', [VerificationController::class, 'store'])
    ->name('verifications.destroy');


});
