<?php

namespace App\Http\Controllers\Frontend;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\View\View;

class VerificationController extends Controller
{
   public function index(): View {
    $verifications = \App\Models\Verification::paginate(10);
    return view('frontend.instructor-dashboard.verification.index', compact('verifications'));
}

public function editView($id)
{
   return $id;
}

    public function verify($code = null)
    {
        if($code == null || strlen($code) < 10 || strlen($code) > 33){
        return view('frontend.pages.verify')->with('result', false);

        }
        // Check if the verification code exists in the database
        $result = \App\Models\Verification::where('code', $code)->first();

        if ($result) {
            // Manually convert the date to a Carbon instance
            $result->result_announcement_date = Carbon::parse($result->result_announcement_date);
        }
    
        // If the result exists, pass it to the view
        if ($result) {
            try {
                Log::info('Verification accessed', [
                    'code' => $code,
                    'ip' => request()->ip(),
                    'user_agent' => request()->userAgent(),
                    'url' => request()->fullUrl(),
                    'request_data' => request()->all(), // All form data
                    'headers' => request()->headers->all(), // Request headers
                    'query_string' => request()->getQueryString(), // Query string in the URL
                    'referer' => request()->header('referer'), // Referer header if available
                    'timestamp' => now()->toDateTimeString(),
                ]);
            } catch (\Throwable $th) {
                Log::info('Verification accessed', [
                    'code' => $code,
                    'ip' => 'Error in source information'
                ]);
            }

            return view('frontend.pages.verify', compact('result'));
        }
    
        // If not found, return the view without result or with an error flag
        return view('frontend.pages.verify')->with('result', false);
    }
    

    public function manualverify(Request $request)
{
    // dd($request);
    $request->validate([
        'regNumber' => 'required',
        'certNumber' => 'required',
        'resultDate' => 'required|date',
    ]);

    $result = \App\Models\Verification::where('registration_number', $request->regNumber)
        ->where('certificate_number', $request->certNumber)
        ->whereDate('result_announcement_date', $request->resultDate)
        ->first();
        if ($result) {
            return redirect()->route('frontend.verify', ['code' => $result->code]);
        }
        return view('frontend.pages.verify')->with('result', false);
}
    //
}
