<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('verifications', function (Blueprint $table) {
            $table->id();

            // Unique QR verification code
            $table->string('code', 64)->unique();

            // Personal Info
            $table->string('student_name');
            $table->string('father_name');
            $table->string('cnic_number', 15);
            $table->date('date_of_birth');

            // Academic Info
            $table->string('grade');
            $table->decimal('percentage', 5, 2);
            $table->string('session');
            $table->string('college');
            $table->string('diploma_title');
            $table->string('diploma_tenure');
            $table->date('result_announcement_date');
            $table->string('registration_number',128)->unique();

            // Status (for internal tracking)
            $table->enum('status', ['active', 'used', 'expired'])->default('active');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('verifications');
    }
};
