@extends('frontend.instructor-dashboard.layouts.master')

@section('dashboard-contents')
    <div class="dashboard__content-wrap pb-0">
        <div class="dashboard__content-title d-flex flex-wrap justify-content-between">
            <h4 class="title">{{ __('All Verifications') }}</h4>
            <a href="#" class="btn btn-primary btn-hight-basic disabled">{{ __('Add New') }}</a>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table dash_instructor_course">
                    <div class="row">
                        <div class="col-12">
                            <div class="tab-content" id="verificationTabContent">
                                @forelse($verifications as $verification)
                                    <div class="tab-pane fade show active" id="all-tab-pane" role="tabpanel">
                                        <div class="dashboard-courses-active dashboard_courses">
                                            <div class="courses__item courses__item-two shine__animate-item">
                                                <div class="row align-items-center">
                                                    <div class="col-xl-12">
                                                        <div class="courses__item-content courses__item-content-two">
                                                            <ul class="edit_btn d-flex flex-wrap">
                                                                <li>
                                                                    <a href="{{ route('instructor.verifications.edit-view', $verification->code) }}">
                                                                        <i class="far fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ul>

                                                            <h5 class="title">
                                                                {{ $verification->student_name }} ({{ $verification->registration_number }})
                                                            </h5>

                                                            <div class="courses__item-content-bottom mt-2">
                                                                <div><strong>CNIC:</strong> {{ $verification->cnic_number }}</div>
                                                                <div><strong>College:</strong> {{ $verification->college }}</div>
                                                                <div><strong>Session:</strong> {{ $verification->session }}</div>
                                                                <div><strong>Status:</strong> {{ ucfirst($verification->status) }}</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <div class="col-12">
                                        <div class="text-center">
                                            <h6>{{ __('No Verifications Found') }}</h6>
                                        </div>
                                    </div>
                                @endforelse
                                {{ $verifications->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
