@extends('frontend.layouts.master')
@section('meta_title', 'Verification | Bright Future')
@section('meta_description', 'Verify documents using Bright Future secure QR code verification system.')
@section('contents')
    <!-- breadcrumb-area -->
    {{-- <x-frontend.breadcrumb :title="__('Contact Us')" :links="[['url' => route('home'), 'text' => __('Home')], ['url' => '', 'text' => __('Contact Us')]]" /> --}}
    <!-- breadcrumb-area-end -->
    <!-- contact-area -->
    <style>
    
    <style>
    .table-striped-columns th:nth-child(1),
    .table-striped-columns th:nth-child(3) {
        background-color: var(--bs-table-striped-bg);
        /* Optional: make it bold or give padding */
        font-weight: 500;
    }

    @media print {
    body * {
        visibility: hidden;
    }

    .print-area, .print-area * {
        visibility: visible;
    }

    .print-area {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }

    .no-print {
        display: none !important;
    }
}
</style>
  
    <section class="contact-area pt-24">
        <div style="margin-top:50px; margin-bottom:50px" class="container">
            <!-- Contact Map Section -->
            @if($result)
            <div class="container print-area">
                <div class="verification-success text-center">
                    {{-- <img src="https://brightfuture.pk/uploads/custom-images/wsus-img-2025-03-25-03-24-06-4097.png" alt="Verified"> --}}
                    <div style="max-width: 70px;margin:auto;" class="text-center my-4">
                        <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 116.87"><defs><style>.cls-1{fill:#198754;fill-rule:evenodd;}.cls-2{fill:#fff;}</style></defs><title>verified-symbol</title><polygon class="cls-1" points="61.37 8.24 80.43 0 90.88 17.79 111.15 22.32 109.15 42.85 122.88 58.43 109.2 73.87 111.15 94.55 91 99 80.43 116.87 61.51 108.62 42.45 116.87 32 99.08 11.73 94.55 13.73 74.01 0 58.43 13.68 42.99 11.73 22.32 31.88 17.87 42.45 0 61.37 8.24 61.37 8.24"/><path class="cls-2" d="M37.92,65c-6.07-6.53,3.25-16.26,10-10.1,2.38,2.17,5.84,5.34,8.24,7.49L74.66,39.66C81.1,33,91.27,42.78,84.91,49.48L61.67,77.2a7.13,7.13,0,0,1-9.9.44C47.83,73.89,42.05,68.5,37.92,65Z"/></svg>
                    </div>
                    <h2 class="text-success fs-2 fs-md-1" style="color: var(--bs-success);">Verification Successful </h2>
                    <p>The certificate has been successfully verified and matched in our records.</p>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class=" mt-4">
                            <div class="">
                                <div class="invoice-title text-center">
                                    <h6 class="card-subtitle text-secondary mb-1">
                                        Dated: {{ $result->result_announcement_date->format('d-m-Y') }}
                                    </h6>
                                    <div class="mb-4">
                                        <h2 class="mb-1 fs-1 fs-md-1">{{ $result->student_name }}</h2>
                                    </div>
                                    <div class="text-muted">
                                        <p><strong>Certificate  Title:</strong> {{ $result->diploma_title }} ({{ $result->diploma_tenure }})</p>
                                    </div>
                                </div>
            
                                <hr class="my-4">
             
                        
                             

                                <h4 class="title mb-3 mt-5">Student Details</h4>
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped-columns">
                                    <tbody>
                                        <tr>
                                            <th>Student Name</th>
                                            <td>{{ $result->student_name }}</td>
                                            <th>Father Name</th>
                                            <td>{{ $result->father_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>CNIC Number</th>
                                            <td>{{ $result->cnic_number }}</td>
                                            <th>Date of Birth</th>
                                            <td>{{ \Carbon\Carbon::parse($result->date_of_birth)->format('d-m-Y') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Registration #</th>
                                            <td>{{ $result->registration_number }}</td>
                                            <th>Session</th>
                                            <td>{{ $result->session }}</td>
                                        </tr>
                                        <tr>
                                            <th>Grade</th>
                                            <td>{{ $result->grade }}</td>
                                            <th>Percentage</th>
                                            <td>{{ $result->percentage }}%</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                                <h4 class="title mb-3 mt-5">Institute Information</h4>

                                <table class="table table-bordered table-hover">
                                    <tbody>
                                        <tr>
                                            <th>College</th>
                                            <td>{{ $result->college }}</td>
                                        </tr>
                                        <tr>
                                            <th>Mode of Education</th>
                                            <td>Onsite (Regular)</td>
                                        </tr>
                                    
                                        <tr>
                                            <th>Result Announcement Date</th>
                                            <td>{{ \Carbon\Carbon::parse($result->result_announcement_date)->format('d-m-Y') }}</td>
                                        </tr>
                                    </tbody>
                                </table>
            
                                <hr class="my-4">
            
                                <div class="d-print-none mt-4">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-success me-1">
                                            <i class="fa fa-print"></i> Print
                                        </a>
                                        {{-- <a href="#" class="btn btn-primary w-md">Download</a> --}}
                                    </div>
                                </div>
            
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @else
                <div class="verification-message">
                    <div class="container py-5">
                        <div class="text-center mb-4">
                          <h2>Certificate Verification</h2>
                          <p class="lead">Please enter the required information below to verify the certificate.</p>
                        </div>
                      
                        <div class="row justify-content-center">
                          <div class="col-md-6">
                            <form method="POST" action="{{ route('verify.certificate') }}" class="needs-validation" novalidate>
                             @csrf
                                <div class="mb-3">
                                <label for="regNumber" class="form-label">Registration Number</label>
                                <input type="text" class="form-control" name="regNumber" id="regNumber" placeholder="XXXX-XXX-XXX-XXXX" required>
                                <div class="invalid-feedback">
                                  Registration number is required.
                                </div>
                              </div>
                      
                              <div class="mb-3">
                                <label for="certNumber" class="form-label">Certificate Number</label>
                                <input type="text" class="form-control" name="certNumber" id="certNumber" placeholder="Enter certificate number" required>
                                <div class="invalid-feedback">
                                  Certificate number is required.
                                </div>
                              </div>
                      
                              <div class="mb-3">
                                <label for="resultDate" class="form-label">Result Declaration Date</label>
                                <input type="date" class="form-control" name="resultDate" id="resultDate" required>
                                <div class="invalid-feedback">
                                  Result date is required.
                                </div>
                              </div>
                      
                              <button class="btn btn-primary mt-4 w-100" type="submit">Verify</button>
                            </form>
                          </div>
                          <p class="text-center mt-4">
                            If you encounter any issues with the verification process, please contact us at 
                            <strong>admin@brightfuture.pk</strong>.
                        </p>
                        </div>
                      </div>
                </div>
            @endif
            <!-- Contact Map Section End -->
        </div>
    </section>
    <!-- contact-area-end -->
    <script>
        // Bootstrap form validation
        (() => {
          'use strict';
          const forms = document.querySelectorAll('.needs-validation');
          Array.from(forms).forEach(form => {
            form.addEventListener('submit', event => {
              if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
              }
              form.classList.add('was-validated');
            }, false);
          });
        })();
      </script>
@endsection
