<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Manage Addons')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Manage Addons')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Manage Addons')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4><?php echo e(__('Manage Addons')); ?></h4>
                                <div class="card-header-action">
                                    <?php if(auth()->guard('admin')->user()->can('addon.install')): ?>
                                        <a class="btn btn-success" href="<?php echo e(route('admin.addons.install')); ?>"><i
                                                class="fas fa-plus"></i>
                                            <?php echo e(__('Install New')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php $__empty_1 = true; $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            $options = json_decode($addon->options, true);
                                            $route =
                                                isset($options['setting_route']) && count($options) > 0
                                                    ? $options['setting_route']
                                                    : false;
                                        ?>
                                        <div class="text-center col-lg-3 col-md-6 col-sm-12">
                                            <div class="p-1 border card">
                                                <div class="card-body">
                                                    <?php if($addon->icon): ?>
                                                        <img src="<?php echo e($addon->icon); ?>" alt="">
                                                    <?php endif; ?>
                                                    <h4><?php echo e($addon->name); ?></h4>
                                                    <p class="card-text"><?php echo e($addon->description); ?></p>
                                                    <p class="card-text"><?php echo e(__('version')); ?>: <?php echo e($addon->version); ?></p>
                                                    <p class="card-text"><?php echo e(__('Update')); ?>: <?php echo e($addon->last_update); ?>

                                                    </p>
                                                    <?php if($addon->is_default): ?>
                                                        <button class="btn btn-success" type="button"
                                                            disabled><?php echo e(__('Installed')); ?></button>
                                                        <?php else: ?>
                                                            <?php if($route && $addon->status && Route::has($route)): ?>
                                                                <a class="btn btn-primary" href="<?php echo e(route($route)); ?>"
                                                                    target="_blank" rel="noopener noreferrer">
                                                                    <i class="fas fa-cogs"></i>
                                                                </a>
                                                            <?php endif; ?>
                                                            <?php if($addon->status): ?>
                                                                <a class="btn btn-warning"
                                                                    href="<?php echo e(route('admin.addons.update.status', $addon->slug)); ?>"><?php echo e(__('Disable')); ?></a>
                                                            <?php else: ?>
                                                                <a class="btn btn-success"
                                                                    href="<?php echo e(route('admin.addons.update.status', $addon->slug)); ?>"><?php echo e(__('Enable')); ?></a>
                                                            <?php endif; ?>
                                                            <a class="btn btn-danger" data-toggle="modal"
                                                                data-target="#deleteModal" href="javascript:;"
                                                                onclick="deleteData('<?php echo e(route('admin.addons.uninstall', $addon->slug)); ?>')"><?php echo e(__('Uninstall')); ?></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <table class="table table-striped">
                                            <tbody>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Post'),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '1'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            </tbody>
                                        </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    </div>

    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        function deleteData(url) {
            $("#deleteForm").attr("action", url)
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\addons\manage_addon.blade.php ENDPATH**/ ?>