<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Create')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Course')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Course')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="dashboard__content-wrap">
                    <div class="row">
                        <div class="col-12">
                            <?php echo $__env->make('course::course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <div class="card">
                                <div class="card-body">
                                    <div class="instructor__profile-form-wrap mt-4">
                                        <form action="<?php echo e(route('admin.courses.store', ['id' => @$course?->id])); ?>"
                                            class="instructor__profile-form course-form">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="step" value="1">
                                            <input type="hidden" name="next_step" value="2">
                                            <input type="hidden" name="edit_mode"
                                                value="<?php echo e(isset($editMode) && $editMode == true ? true : false); ?>">

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="instructor"><?php echo e(__('Instructor')); ?>

                                                            <code>*</code></label>
                                                        <select name="instructor" id=""
                                                            class="form-control select2">
                                                            <option value=""><?php echo e(__('Select')); ?></option>
                                                            <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($instructor->id); ?>"
                                                                    <?php if($instructor->id == @$course?->instructor_id): echo 'selected'; endif; ?>><?php echo e($instructor->name); ?>

                                                                    (<?php echo e($instructor->email); ?>)</option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="title"><?php echo e(__('Title')); ?> <code>*</code></label>
                                                        <input id="title" name="title" type="text"
                                                            class="form-control" value="<?php echo e(@$course?->title); ?>">
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="seo_description"><?php echo e(__('Seo description')); ?>

                                                            <code></code></label>
                                                        <input id="seo_description" name="seo_description" type="text"
                                                            value="<?php echo e(@$course?->seo_description); ?>" class="form-control"
                                                            placeholder="<?php echo e(__('150 - 160 characters recommended')); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="from-group mb-3">
                                                        <label class="form-file-manager-label"
                                                            for=""><?php echo e(__('Thumbnail')); ?>

                                                            <code>* (<?php echo e(__('Recommended')); ?>: 690X420 PX)</code></label>
                                                        <div class="input-group">
                                                            <span class="input-group-text" id="basic-addon1">
                                                                <a data-input="thumbnail" data-preview="holder"
                                                                    class="file-manager-image">
                                                                    <i class="fa fa-picture-o"></i> <?php echo e(__('Choose')); ?>

                                                                </a>
                                                            </span>
                                                            <input id="thumbnail" readonly
                                                                class="form-control file-manager-input" type="text"
                                                                name="thumbnail" value="<?php echo e(@$course?->thumbnail); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="demo_video_storage"><?php echo e(__('Demo Video Storage')); ?>

                                                            <code>(<?php echo e(__('optonal')); ?>)</code></label>
                                                        <select name="demo_video_storage" id="demo_video_storage"
                                                            class="form-control">
                                                            <option <?php if(@$course?->demo_video_storage == 'upload'): echo 'selected'; endif; ?> value="upload">
                                                                <?php echo e(__('upload')); ?>

                                                            </option>
                                                            <option <?php if(@$course?->demo_video_storage == 'youtube'): echo 'selected'; endif; ?> value="youtube">
                                                                <?php echo e(__('youtube')); ?></option>
                                                            <option <?php if(@$course?->demo_video_storage == 'vimeo'): echo 'selected'; endif; ?> value="vimeo">
                                                                <?php echo e(__('vimeo')); ?>

                                                            </option>
                                                            <option <?php if(@$course?->demo_video_storage == 'external_link'): echo 'selected'; endif; ?> value="external_link">
                                                                <?php echo e(__('external_link')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div
                                                    class="col-md-6 upload <?php echo e(@$course?->demo_video_storage == 'upload' ? '' : 'd-none'); ?>">
                                                    <div class="from-group mb-3">
                                                        <label class="form-file-manager-label"
                                                            for=""><?php echo e(__('Path')); ?>

                                                            <code></code></label>
                                                        <div class="input-group">
                                                            <span class="input-group-text" id="basic-addon1">
                                                                <a data-input="path" data-preview="holder"
                                                                    class="file-manager">
                                                                    <i class="fa fa-picture-o"></i> <?php echo e(__('Choose')); ?>

                                                                </a>
                                                            </span>
                                                            <input id="path" readonly
                                                                class="form-control file-manager-input" type="text"
                                                                name="upload_path"
                                                                value="<?php echo e(@$course?->demo_video_source); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div
                                                    class="col-md-6 external_link <?php echo e(@$course?->demo_video_storage != 'upload' ? '' : 'd-none'); ?>">
                                                    <div class="form-grp">
                                                        <label for="meta_description"><?php echo e(__('Path')); ?>

                                                            <code></code></label>
                                                        <div class="input-group mb-3">
                                                            <span class="input-group-text" id="basic-addon1"><i
                                                                    class="fas fa-link"></i></span>
                                                            <input type="text" class="form-control"
                                                                name="external_path"
                                                                placeholder="<?php echo e(__('peste your external link')); ?>"
                                                                value="<?php echo e(@$course?->demo_video_source); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="price"><?php echo e(__('Price')); ?> <code>*</code></label>
                                                        <input id="price" name="price" type="text"
                                                            class="form-control" value="<?php echo e(@$course?->price); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="discount_price"><?php echo e(__('Discount Price')); ?>

                                                            <code></code></label>
                                                        <input id="discount_price" name="discount_price" type="text"
                                                            class="form-control" value="<?php echo e(@$course?->discount); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="description"><?php echo e(__('Description')); ?>

                                                            <code>*</code></label>
                                                        <textarea name="description" class="text-editor form-control summernote"><?php echo clean(@$course?->description); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <button class="btn btn-primary" type="submit"><?php echo e(__('Save')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .dd-custom-css {
            position: absolute;
            will-change: transform;
            top: 0px;
            left: 0px;
            transform: translate3d(0px, -131px, 0px);
        }

        .max-h-400 {
            min-height: 400px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules/Course\resources/views/course/create.blade.php ENDPATH**/ ?>