<div class="tab-pane fade show <?php echo e(session('profile_tab') == 'profile' ? 'active': ''); ?>" id="itemOne-tab-pane" role="tabpanel" aria-labelledby="itemOne-tab" tabindex="0">
    <div class="instructor__cover-bg preview-cover-img" data-background="<?php echo e(asset($user->cover)); ?>">
        <div class="instructor__cover-info">
            <div class="instructor__cover-info-left">
                <div class="thumb">
                    <img class="preview-avatar" src="<?php echo e(asset($user->image)); ?>"
                        alt="img">
                </div>
                <button title="Upload Photo" onclick="$('#avatar').trigger('click')"><i
                        class="fas fa-camera"></i></button>

            </div>
            <div class="instructor__cover-info-right">
                <a href="javascript:;" onclick="$('#cover-img').trigger('click')"
                    class="btn btn-two arrow-btn"><?php echo e(__('Edit Cover Photo')); ?></a>
            </div>
        </div>
    </div>
    <div class="instructor__profile-form-wrap">
        <form action="<?php echo e(route('student.setting.profile.update')); ?>" method="POST" enctype="multipart/form-data" class="instructor__profile-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <input type="file" name="avatar" id="avatar" hidden>
            <input type="file" name="cover" id="cover-img" hidden>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-grp">
                        <label for="name"><?php echo e(__('Full Name')); ?> <code>*</code></label>
                        <input id="name" name="name" type="text" value="<?php echo e($user->name); ?>">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-grp">
                        <label for="email"><?php echo e(__('Email')); ?> <code>*</code></label>
                        <input id="email" name="email" type="email" value="<?php echo e($user->email); ?>">

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-grp">
                        <label for="phone"><?php echo e(__('Phone')); ?></label>
                        <input id="phone" name="phone" type="text" value="<?php echo e($user->phone); ?>">

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-grp">
                        <label for="gender"><?php echo e(__('Gender')); ?></label>
                        <select name="gender" id="gender" class="form-select">
                            <option value=""><?php echo e(__('Select')); ?></option>
                            <option <?php if($user->gender == 'male'): echo 'selected'; endif; ?> value="male"><?php echo e(__('Male')); ?></option>
                            <option <?php if($user->gender == 'female'): echo 'selected'; endif; ?> value="female"><?php echo e(__('Female')); ?></option>
                        </select>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-grp">
                        <label for="age"><?php echo e(__('Age')); ?></label>
                        <input id="age" name="age" type="text" value="<?php echo e($user->age); ?>">
                    </div>
                </div>

            </div>

            <div class="submit-btn mt-25">
                <button type="submit" class="btn"><?php echo e(__('Update Info')); ?></button>
            </div>
        </form>
    </div>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\profile\sections\profile.blade.php ENDPATH**/ ?>