<?php $__env->startSection('meta_title', $course->title . ' || ' . $setting->app_name); ?>

<?php $__env->startSection('contents'); ?>

    <section class="wsus__course_video">
        <div class="col-12">
            <div class="wsus__course_header">
                <a href="<?php echo e(route('student.dashboard')); ?>"><i class="fas fa-angle-left"></i>
                    <?php echo e(__('Go back to dashboard')); ?></a>
                <p><?php echo e(__('Your Progress')); ?>: <?php echo e($courseLectureCompletedByUser); ?> <?php echo e(__('of')); ?>

                    <?php echo e($courseLectureCount); ?> (<?php echo e(number_format($courseCompletedPercent)); ?>%)</p>

                <div class="wsus__course_header_btn">
                    <i class="fas fa-stream"></i>
                </div>
            </div>
        </div>

        <div class="wsus__course_video_player">

            
            <div class="video-payer position-relative">
                <div class="player-placeholder">
                    <div class="preloader-two player">
                        <div class="loader-icon-two player"><img src="<?php echo e(asset(Cache::get('setting')->preloader)); ?>"
                                alt="Preloader">
                        </div>
                    </div>
                </div>
            </div>

            
            <?php echo $__env->make('frontend.pages.learning-player.bottom-panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>


        <div class="wsus__course_sidebar">
            <div class="wsus__course_sidebar_btn">
                <i class="fas fa-times"></i>
            </div>
            <h2 class="video_heading"><?php echo e(__('Course Content')); ?></h2>
            <div class="accordion" id="accordionExample">
                <?php $__currentLoopData = $course->chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse-<?php echo e($chapter->id); ?>" aria-expanded="false"
                                aria-controls="collapse-<?php echo e($chapter->id); ?>">
                                <b><?php echo e($chapter->title); ?></b>
                                <span></span>
                            </button>
                        </h2>
                        <div id="collapse-<?php echo e($chapter->id); ?>"
                            class="accordion-collapse collapse <?php echo e($currentProgress?->chapter_id == $chapter->id ? 'show' : ''); ?>"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body course-content">
                                <?php $__currentLoopData = $chapter->chapterItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapterItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($chapterItem->type == 'lesson' || $chapterItem->type == 'live'): ?>
                                        <div
                                            class="form-check <?php echo e($chapterItem->lesson->id == $currentProgress?->lesson_id ? 'item-active' : ''); ?>">
                                            <input <?php if(in_array($chapterItem->lesson->id, $alreadyWatchedLectures)): echo 'checked'; endif; ?>
                                                class="form-check-input lesson-completed-checkbox" type="checkbox"
                                                data-lesson-id="<?php echo e($chapterItem->lesson->id); ?>" value="1"
                                                data-type="lesson">
                                            <label class="form-check-label lesson-item"
                                                data-lesson-id="<?php echo e($chapterItem->lesson->id); ?>"
                                                data-chapter-id="<?php echo e($chapter->id); ?>" data-course-id="<?php echo e($course->id); ?>"
                                                data-type="<?php echo e($chapterItem->type); ?>">
                                                <?php echo e($chapterItem->lesson->title); ?>

                                                <span>
                                                    <img src="<?php echo e($chapterItem->type == 'live' ? asset('frontend/img/live.png') : asset('frontend/img/video_icon_black_2.png')); ?>"
                                                        alt="video" class="img-fluid">
                                                    <?php echo e($chapterItem->lesson->duration ? minutesToHours($chapterItem->lesson->duration) : '--.--'); ?>

                                                </span>
                                            </label>
                                        </div>
                                    <?php elseif($chapterItem->type == 'document'): ?>
                                        <div
                                            class="form-check <?php echo e($chapterItem->lesson->id == $currentProgress?->lesson_id ? 'item-active' : ''); ?>">
                                            <input <?php if(in_array($chapterItem->lesson->id, $alreadyWatchedLectures)): echo 'checked'; endif; ?>
                                                class="form-check-input lesson-completed-checkbox" type="checkbox"
                                                data-lesson-id="<?php echo e($chapterItem->lesson->id); ?>" value="1"
                                                data-type="document">
                                            <label class="form-check-label lesson-item"
                                                data-lesson-id="<?php echo e($chapterItem->lesson->id); ?>"
                                                data-chapter-id="<?php echo e($chapter->id); ?>" data-course-id="<?php echo e($course->id); ?>"
                                                data-type="document">
                                                <?php echo e($chapterItem->lesson->title); ?>

                                                <span>
                                                    <img src="<?php echo e(asset('frontend/img/' . $chapterItem->lesson->file_type . '.png')); ?>"
                                                        alt="video" class="img-fluid">
                                                    --.--
                                                </span>
                                            </label>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-check">
                                            <input <?php if(in_array($chapterItem->quiz->id, $alreadyCompletedQuiz)): echo 'checked'; endif; ?>
                                                class="form-check-input lesson-completed-checkbox" type="checkbox"
                                                data-lesson-id="<?php echo e($chapterItem->quiz->id); ?>" value="1"
                                                data-type="quiz">
                                            <label class="form-check-label lesson-item"
                                                data-chapter-id="<?php echo e($chapter->id); ?>" data-course-id="<?php echo e($course->id); ?>"
                                                data-lesson-id="<?php echo e($chapterItem->quiz->id); ?>" data-type="quiz">
                                                <?php echo e($chapterItem->quiz->title); ?>

                                                <span>
                                                    <img src="<?php echo e(asset('frontend/img/video_icon_black_2.png')); ?>"
                                                        alt="video" class="img-fluid">
                                                    --.--
                                                </span>
                                            </label>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        var preloader_path = "<?php echo e(asset(Cache::get('setting')->preloader)); ?>";
        var watermark = "<?php echo e(property_exists($setting, 'watermark_img') ? asset($setting->watermark_img) : ''); ?>";
    </script>
    <script src="<?php echo e(asset('frontend/js/videojs-watermark.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/default/learning-player.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/default/quiz-page.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/default/qna.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/default/qna.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/pdf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/docx-preview.min.js')); ?>"></script>
    <script>
        "use strict";
        $(document).ready(function() {
            // reset quiz timer
            resetCountdown();
            // auto click on current lesson
            var lessonId = "<?php echo e(request('lesson')); ?>";
            var type = "<?php echo e(request('type')); ?>";
            var currentLessonSelector = $(
                '.lesson-item[data-lesson-id="<?php echo e($currentProgress?->lesson_id); ?>"][data-type="<?php echo e($currentProgress?->type); ?>"]'
            );
            var targetLessonSelector = $(`.lesson-item[data-lesson-id="${lessonId}"][data-type="${type}"]`);

            if (targetLessonSelector.length) {
                targetLessonSelector.trigger('click');
            } else if (currentLessonSelector.length) {
                currentLessonSelector.trigger('click');
            } else {
                $('.lesson-item:first').trigger('click');
            }

        })
    </script>
    <script src="<?php echo e(asset('frontend/js/custom-tinymce.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('styles'); ?>
    <style>
.vjs-watermark {
    max-width: <?php echo e($setting?->max_width ?? '300'); ?>px;
    opacity: <?php echo e($setting?->opacity ?? '0.7'); ?> !important;
    <?php $position =$setting?->position ?? 'top_right'; ?>
    <?php if($position === 'top_left'): ?>
    top: 0;
    left: 0;
    <?php elseif($position === 'bottom_right'): ?> 
    bottom: 44px;
    right: 0;
    <?php elseif($position === 'bottom_left'): ?> 
    bottom: 44px;
    left: 0;
    <?php else: ?>
    top: 0;
    right: 0;
    <?php endif; ?>
    <?php if((property_exists($setting, 'watermark_status') ? $setting?->watermark_status : 'inactive')  === 'active'): ?>
    display:inline;
    <?php endif; ?>
}
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.pages.learning-player.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\pages\learning-player\index.blade.php ENDPATH**/ ?>