<?php $__env->startSection('dashboard-contents'); ?>
    <?php if(instructorStatus() == 'pending'): ?>
        <div class="alert alert-primary d-flex align-items-center" role="alert">
            <svg 0 16 xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 16" role="img" aria-label="Warning:">
                <path 0 1 2 8
                    d="M8.982 1.566a1.13 1.13 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 .954.462.9.995l-.35 3.507a.552.552 1-1.1 0L7.1 5.995A.905.905 5zm.002 6a1 0-2z" />
                </path>
            </svg>
            <div>
                <?php echo e(__('We received your request to become instructor')); ?>. <?php echo e(__('Please wait for admin approval')); ?>!
            </div>
        </div>
    <?php elseif(instructorStatus() == 'rejected'): ?>
        <div class="alert alert-danger d-flex align-items-center" role="alert">
            <svg 0 16 xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 16" role="img"
                aria-label="Warning:">
                <path 0 1 2 8
                    d="M8.982 1.566a1.13 1.13 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 .954.462.9.995l-.35 3.507a.552.552 1-1.1 0L7.1 5.995A.905.905 5zm.002 6a1 0-2z" />
                </path>
            </svg>
            <div>
                <?php echo e(__('Your request to become instructor has been rejected. Please resubmit your request with valid information')); ?>

                <a href="<?php echo e(route('become-instructor')); ?>"><?php echo e(__('here')); ?></a>
            </div>
        </div>
    <?php endif; ?>


    <div class="dashboard__content-wrap dashboard__content-wrap-two mb-60">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Dashboard')); ?></h4>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count odometer" data-count="<?php echo e($totalEnrolledCourses); ?>"></span>
                        <p><?php echo e(__('ENROLLED COURSES')); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <img src="<?php echo e(asset('uploads/website-images/quiz.svg')); ?>">
                    </div>
                    <div class="content">
                        <span class="count odometer" data-count="<?php echo e($totalQuizAttempts); ?>"></span>
                        <p><?php echo e(__('QUIZ ATTEMPTS')); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <img src="<?php echo e(asset('uploads/website-images/reviews.svg')); ?>">
                    </div>
                    <div class="content">
                        <span class="count odometer" data-count="<?php echo e($totalReviews); ?>"></span>
                        <p><?php echo e(__('YOUR TOTAL REVIEWS')); ?></p>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Order History')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Invoice')); ?></th>
                                <th><?php echo e(__('Paid')); ?></th>
                                <th><?php echo e(__('Gateway')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Payment')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(++$index); ?></td>
                                    <td>#<?php echo e($order->invoice_id); ?></td>
                                    <td><?php echo e($order->paid_amount); ?> <?php echo e($order->payable_currency); ?></td>
                                    <td>
                                        <?php echo e($order->payment_method); ?>

                                    </td>
                                    <td>
                                        <?php if($order->status == 'completed'): ?>
                                            <div class="badge bg-success"><?php echo e(__('Completed')); ?></div>
                                        <?php elseif($order->status == 'processing'): ?>
                                            <div class="badge bg-warning"><?php echo e(__('Processing')); ?></div>
                                        <?php elseif($order->status == 'declined'): ?>
                                            <div class="badge bg-danger"><?php echo e(__('Declined')); ?></div>
                                        <?php else: ?>
                                            <div class="badge bg-warning"><?php echo e(__('Pending')); ?></div>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if($order->payment_status == 'paid'): ?>
                                            <div class="badge bg-success"><?php echo e(__('Paid')); ?></div>
                                        <?php elseif($order->payment_status == 'cancelled'): ?>
                                            <div class="badge bg-danger"><?php echo e(__('Cancelled')); ?></div>
                                        <?php else: ?>
                                            <div class="badge bg-danger"><?php echo e(__('Pending')); ?></div>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('student.order.show', $order->id)); ?>" class=""><i
                                                class="fa fa-eye"></i></a>
                                        <?php if($order->status == 'pending'): ?>
                                            <a target="_blank"
                                                href="<?php echo e(route('payment', ['invoice_id' => $order->invoice_id])); ?>"
                                                class="bg-info"><i class="fa fa-credit-card"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="10" class="text-center"><?php echo e(__('No orders found!')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\index.blade.php ENDPATH**/ ?>