<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap pb-0">
        <div class="dashboard__content-title d-flex flex-wrap justify-content-between">
            <h4 class="title"><?php echo e(__('All Courses')); ?></h4>
            <a href="<?php echo e(route('instructor.courses.create')); ?>"
                class="btn btn-primary btn-hight-basic"><?php echo e(__('Add Course')); ?></a>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table dash_instructor_course">
                    <div class="row">
                        <div class="col-12">
                            <div class="tab-content" id="courseTabContent">
                                <?php $__empty_1 = true; $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="tab-pane fade show active" id="all-tab-pane" role="tabpanel"
                                        aria-labelledby="all-tab" tabindex="0">
                                        <div class="dashboard-courses-active dashboard_courses">
                                            <div class="courses__item courses__item-two shine__animate-item">
                                                <div class="row align-items-center">
                                                    <div class="col-xl-5">
                                                        <div class="courses__item-thumb courses__item-thumb-two">
                                                            <a href="<?php echo e(route('instructor.courses.edit-view', $course->id)); ?>"
                                                                class="shine__animate-link">
                                                                <img src="<?php echo e(asset($course->thumbnail)); ?>" alt="img">
                                                            </a>
                                                            <?php if($course->is_approved == 'pending'): ?>
                                                                <p class="bg-warning"><?php echo e(__('Pending')); ?></p>
                                                            <?php elseif($course->is_approved == 'rejected'): ?>
                                                                <p><?php echo e(__('Rejected')); ?></p>
                                                            <?php else: ?>
                                                                <?php if($course->status == 'active'): ?>
                                                                    <p class="bg-success"><?php echo e(__('Published')); ?></p>
                                                                <?php elseif($course->status == 'inactive'): ?>
                                                                    <p class="bg-danger"><?php echo e(__('Unpublished')); ?></p>
                                                                <?php else: ?>
                                                                    <p class="bg-danger"><?php echo e(__('Draft')); ?></p>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-7">
                                                        <div class="courses__item-content courses__item-content-two">
                                                            <ul class="courses__item-meta list-wrap">
                                                                <?php if(@$course->category->translation->name): ?>
                                                                    <li class="courses__item-tag">
                                                                        <a
                                                                            href="javascript:;"><?php echo e(@$course->category->translation->name); ?></a>
                                                                    </li>
                                                                <?php endif; ?>
                                                            </ul>
                                                            <ul class="edit_btn d-flex flex-wrap">
                                                                <li>
                                                                    <a
                                                                        href="<?php echo e(route('instructor.courses.edit-view', $course->id)); ?>">
                                                                        <i class="far fa-edit"></i>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a type="button" class="course-delete-request"
                                                                        href="<?php echo e(route('instructor.course.delete-request.show', $course->id)); ?>">
                                                                        <i class="fas fa-trash-alt"></i>
                                                                    </a>
                                                                </li>
                                                            </ul>

                                                            <h5 class="title"><a
                                                                    href="<?php echo e(route('instructor.courses.edit-view', $course->id)); ?>"><?php echo e($course->title); ?></a>
                                                            </h5>
                                                            <div class="courses__item-content-bottom">
                                                                <div class="author-two">
                                                                    <a href="javascript:;"><img
                                                                            src="<?php echo e(asset($course->instructor->image)); ?>"
                                                                            alt="img"><?php echo e($course->instructor->name); ?></a>
                                                                </div>
                                                                <div class="avg-rating">
                                                                    <i class="fas fa-star"></i>
                                                                    <?php echo e(number_format($course->reviews()->avg('rating') ?? 0, 1)); ?>

                                                                </div>
                                                            </div>

                                                        </div>

                                                        <?php
                                                            $courseLectureCount = App\Models\CourseChapterItem::whereHas(
                                                                'chapter',
                                                                function ($q) use ($course) {
                                                                    $q->where('course_id', $course->id);
                                                                },
                                                            )->count();

                                                        ?>

                                                        <div class="courses__item-bottom-two">
                                                            <ul class="list-wrap">
                                                                <li><i class="flaticon-book"></i><?php echo e($courseLectureCount); ?>

                                                                </li>
                                                                <li><i
                                                                        class="flaticon-clock"></i><?php echo e(minutesToHours($course->duration)); ?>

                                                                </li>
                                                                <li><i
                                                                        class="flaticon-mortarboard"></i><?php echo e($course->enrollments()->count()); ?>

                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="col-12">
                                        <div class="text-center">
                                            <h6><?php echo e(__('No Course Found')); ?></h6>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php echo e($courses->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\course\index.blade.php ENDPATH**/ ?>