<div class="tab-pane fade" id="razorpay_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.razorpay-update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Gateway charge (%)')); ?></label>
                <input type="text" class="form-control" name="razorpay_charge"
                    value="<?php echo e($payment_setting->razorpay_charge); ?>">
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Razorpay key')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="razorpay_key"
                        value="demo-razorpay-39394343-test-key">
                <?php else: ?>
                    <input type="text" class="form-control" name="razorpay_key"
                        value="<?php echo e($payment_setting->razorpay_key); ?>">
                <?php endif; ?>
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Razorpay secret')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="razorpay_secret"
                        value="demo-razorpay-8384934-test-secret">
                <?php else: ?>
                    <input type="text" class="form-control" name="razorpay_secret"
                        value="<?php echo e($payment_setting->razorpay_secret); ?>">
                <?php endif; ?>
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Razorpay App Name')); ?></label>
                <input type="text" class="form-control" name="razorpay_name"
                    value="<?php echo e($payment_setting->razorpay_name); ?>">
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Razorpay Description')); ?></label>
                <input type="text" class="form-control" name="razorpay_description"
                    value="<?php echo e($payment_setting->razorpay_description); ?>">
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Theme color')); ?></label>
                <input type="color" class="form-control" name="razorpay_theme_color"
                    value="<?php echo e($payment_setting->razorpay_theme_color); ?>">
            </div>
        </div>

        <div class="form-group">
            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 210X100 PX)</code></label>
            <div id="image-preview-razorpay" class="image-preview">
                <label for="image-upload-razorpay"
                    id="image-label-razorpay"><?php echo e(__('Image')); ?></label>
                <input type="file" name="razorpay_image" id="image-upload-razorpay">
            </div>

        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="razorpay_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="razorpay_status" class="custom-switch-input"
                    <?php echo e($payment_setting?->razorpay_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\razorpay.blade.php ENDPATH**/ ?>