<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Withdraw Details')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Withdraw Details')); ?></h1>

            </div>

            <div class="section-body">
                <a href="<?php echo e(route('admin.withdraw-list')); ?>" class="btn btn-primary"><i class="fas fa-list"></i>
                    <?php echo e(__('withdraw')); ?></a>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-bordered table-striped table-hover">
                                    <tr>
                                        <td width="50%"><?php echo e(__('Name')); ?></td>
                                        <td width="50%">
                                            <a
                                                href="<?php echo e(route('admin.customer-show', $withdraw->user_id)); ?>"><?php echo e($withdraw?->user?->name); ?></a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="50%"><?php echo e(__('Withdraw Method')); ?></td>
                                        <td width="50%"><?php echo e($withdraw->method); ?></td>
                                    </tr>

                                    <tr>
                                        <td width="50%"><?php echo e(__('Current Balance')); ?></td>
                                        <td width="50%">
                                            <?php echo e(currency($withdraw->current_amount)); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="50%"><?php echo e(__('Withdraw Amount')); ?></td>
                                        <td width="50%">
                                            <?php echo e(currency($withdraw->withdraw_amount)); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="50%"><?php echo e(__('Status')); ?></td>
                                        <td width="50%">
                                            <?php if($withdraw->status == 'approved'): ?>
                                                <span class="badge badge-success"><?php echo e(__('Approved')); ?></span>
                                            <?php elseif($withdraw->status == 'rejected'): ?>
                                                <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-warning"><?php echo e(__('Pending')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="50%"><?php echo e(__('Requested Date')); ?></td>
                                        <td width="50%"><?php echo e($withdraw->created_at->format('Y-m-d')); ?></td>
                                    </tr>
                                    <?php if($withdraw->status == 1): ?>
                                        <tr>
                                            <td width="50%"><?php echo e(__('Approved Date')); ?></td>
                                            <td width="50%"><?php echo e($withdraw->approved_date); ?></td>
                                        </tr>
                                    <?php endif; ?>

                                    <tr>
                                        <td width="50%"><?php echo e(__('Account Information')); ?></td>
                                        <td width="50%">
                                            <?php echo clean(nl2br($withdraw->account_info)); ?>

                                        </td>
                                    </tr>

                                </table>


                                <div class="row">
                                    <?php if($withdraw->status == 'pending'): ?>
                                        <div class="col-4">
                                            <form action="<?php echo e(route('admin.update-withdraw-status', $withdraw->id)); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <select name="status" id="status" class="form-control">
                                                    <option value=""><?php echo e(__('Update Status')); ?></option>
                                                    <option value="approved"
                                                        <?php echo e($withdraw->status == 'approved' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Approve')); ?></option>
                                                    <option value="rejected"
                                                        <?php echo e($withdraw->status == 'rejected' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Rejected')); ?></option>
                                                </select>
                                                <button type="submit"
                                                    class="btn btn-primary mt-2"><?php echo e(__('Update Status')); ?></button>
                                            </form>
                                        </div>
                                    <?php endif; ?>

                                   <div class="col-md-4">
                                    <a href="javascript:;" data-toggle="modal" data-target="#deleteModal"
                                    class="btn btn-danger"
                                    onclick="deleteData(<?php echo e($withdraw->id); ?>)"><?php echo e(__('Delete withdraw request')); ?></a>
                                   </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>

    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
    <script>
        "use strict"

        function deleteData(id) {
            $("#deleteForm").attr("action", "<?php echo e(url('admin/delete-withdraw/')); ?>" + "/" + id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\PaymentWithdraw\resources\views\admin\show.blade.php ENDPATH**/ ?>