<div class="dashboard__sidebar-wrap">
    <div class="dashboard__sidebar-title mb-20">
        <h6 class="title"><?php echo e(__('Welcome')); ?>, <?php echo e(userAuth()->name); ?></h6>
    </div>
    <nav class="dashboard__sidebar-menu">
        <ul class="list-wrap">
            <li class="<?php echo e(Route::is('instructor.dashboard') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.dashboard')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/dashboard.svg')); ?>"><?php echo e(__('Dashboard')); ?></a>
            </li>
            <li class="<?php echo e(Route::is('instructor.courses.*') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.courses.index')); ?>">
                    <i class="flaticon-mortarboard"></i>
                    <?php echo e(__('Courses')); ?>

                </a>
            </li>
            <?php if(Module::has('CourseBundle') && Module::isEnabled('CourseBundle')): ?>
                <li class="<?php echo e(Route::is('instructor.course.bundle.*') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('instructor.course.bundle.index')); ?>">
                        <img src="<?php echo e(asset('uploads/website-images/course_bundle.svg')); ?>">
                        <?php echo e(__('Course Bundle')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <li class="<?php echo e(Route::is('instructor.lesson-questions.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.lesson-questions.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/questions.svg')); ?>">
                    <?php echo e(__('Lesson Questions')); ?>

                </a>
            </li>

            <li class="<?php echo e(Route::is('instructor.payout.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.payout.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/payout.svg')); ?>">
                    <?php echo e(__('Request Payout')); ?>

                </a>
            </li>
            <li class="<?php echo e(Route::is('instructor.announcements.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.announcements.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/announcement.svg')); ?>">
                    <?php echo e(__('Announcement')); ?>

                </a>
            </li>
            <li class="<?php echo e(Route::is('instructor.my-sells.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.my-sells.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/sales.svg')); ?>">
                    <?php echo e(__('My Sales')); ?>

                </a>
            </li>
            <li class="<?php echo e(Route::is('instructor.wishlist') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.wishlist')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/heart.svg')); ?>"><?php echo e(__('Wishlist')); ?></a>
            </li>
        </ul>
    </nav>
    <div class="dashboard__sidebar-title mt-30 mb-20">
        <h6 class="title"><?php echo e(__('User')); ?></h6>
    </div>
    <nav class="dashboard__sidebar-menu">
        <ul class="list-wrap">
            <li class="<?php echo e(Route::is('instructor.zoom-setting.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.zoom-setting.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/zoom.svg')); ?>">
                    <?php echo e(__('Zoom live setting')); ?>

                </a>
            </li>
            <li class="<?php echo e(Route::is('instructor.jitsi-setting.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.jitsi-setting.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/zoom.svg')); ?>">
                    <?php echo e(__('Jitsi live setting')); ?>

                </a>
            </li>
            <li class="<?php echo e(Route::is('instructor.setting.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('instructor.setting.index')); ?>">
                    <i class="flaticon-user"></i>
                    <?php echo e(__('Profile Settings')); ?>

                </a>
            </li>
            <li>
                <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); $('#logout-form').trigger('submit');">
                    <img src="<?php echo e(asset('uploads/website-images/logout.svg')); ?>">
                    <?php echo e(__('Logout')); ?>

                </a>
            </li>
        </ul>
    </nav>
</div>


<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
    <?php echo csrf_field(); ?>
</form>

<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\layouts\sidebar.blade.php ENDPATH**/ ?>