<div class="video_tabs_area">
    <ul class="nav nav-pills" id="pills-tab2" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home"
                type="button" role="tab" aria-controls="pills-home"
                aria-selected="true"><?php echo e(__('Overview')); ?></button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile"
                type="button" role="tab" aria-controls="pills-profile"
                aria-selected="false"><?php echo e(__('Q&A')); ?></button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact"
                type="button" role="tab" aria-controls="pills-contact"
                aria-selected="false"><?php echo e(__('Announcements')); ?></button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-disabled-tab" data-bs-toggle="pill" data-bs-target="#pills-disabled"
                type="button" role="tab" aria-controls="pills-disabled"
                aria-selected="false"><?php echo e(__('Reviews')); ?></button>
        </li>
    </ul>
    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab"
            tabindex="0">
            <div class="video_about">
                <h1><?php echo e(__('About this Lecture')); ?></h1>
                <div class="about-lecture"><?php echo e(__('No description')); ?></div>
            </div>
        </div>
        <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab"
            tabindex="0">
            <div class="video_qna">

                <div class="qna_list_area">
                    <div class="video_qna_top d-flex flex-wrap">
                        <form action="#" class="query-form">
                            <input type="text" placeholder="Search...">
                            <button type="submit"><i class="fas fa-search"></i></button>
                        </form>
                        <ul class="d-flex flex-wrap">
                            <li>

                            </li>
                            <li>
                                <p><?php echo e(__('Filters')); ?>:</p>
                                <div class="select_box">
                                    <select class="filter-type">
                                        <option selected value="current_lecture"><?php echo e(__('Current lecture')); ?></option>
                                        <option value="all_lectures"><?php echo e(__('All lectures')); ?></option>
                                    </select>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="video_qna_list">
                        <div class="d-flex flex-wrap align-items-center justify-content-between">
                            <h3><?php echo e(__('All questions')); ?>.</h3>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#exampleModal">
                                <?php echo e(__('Ask a Question')); ?>

                            </button>
                        </div>
                        <div class="question-list">

                            <div class="text-center pt-3 pb-3">
                                <div class="spinner-border" role="status">
                                    <span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span>
                                </div>
                            </div>

                        </div>

                        <div class="text-center p-5">
                            <form action="#" class="load-more-form">
                                <button type="submit" class="btn load-more-btn"><?php echo e(__('Load More')); ?></button>
                            </form>
                        </div>

                    </div>
                </div>

                <div class="qna_details_area d-none">

                    <a href="#" class="btn arrow-btn back_qna_list mt-4"><?php echo e(__('Back to All Questions')); ?></a>

                    <div class="reply-holder">
                        <div class="text-center pt-3 pb-3">
                            <div class="spinner-border" role="status">
                                <span class="visually-hidden"><?php echo e(__('Loading')); ?>...</span>
                            </div>
                        </div>
                    </div>

                    <div class="qna_details_reply">
                        <form action="#" class="replay-form" method="POST">
                            <?php echo csrf_field(); ?>
                            <textarea name="reply" placeholder="Add reply" class="text-editor-img"></textarea>
                            <!-- g-recaptcha -->
                            <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
                                <div class="form-grp mt-3">
                                    <div class="g-recaptcha"
                                        data-sitekey="<?php echo e(Cache::get('setting')->recaptcha_site_key); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                            <button type="submit" class="btn arrow-btn replay-btn mt-3"><?php echo e(__('submit')); ?></button>
                        </form>
                    </div>

                </div>

            </div>
        </div>
        <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab"
            tabindex="0">
            <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="video_about">
                    <div class="announcement_item">
                        <span><?php echo e(formatDate($announcement->created_at)); ?></span>
                        <h1><?php echo e($announcement->title); ?></h1>
                        <?php echo clean($announcement->announcement); ?>

                    </div>
                </div>
                <div class="border border-1"></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-center mt-2"><?php echo e(__('No announcement available')); ?></p>
            <?php endif; ?>
        </div>
        <div class="tab-pane fade" id="pills-disabled" role="tabpanel" aria-labelledby="pills-disabled-tab"
            tabindex="0">
            <div class="video_review">
                <h2><?php echo e(__('Reviews')); ?></h2>
                <div class="review-holder"></div>

                <div class="text-center mt-3">
                    <form action="" class="load-more-rating" method="GET">
                        <button class="btn btn-primary" type="submit"><?php echo e(__('Load More')); ?></button>
                    </form>
                </div>

                <div class="video_review_imput mt-2">
                    <h2 class="mb-2"><?php echo e(__('Write a review')); ?></h2>

                    <form action="<?php echo e(route('student.add-review')); ?>" class="instructor__profile-form"
                        method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="<?php echo e($course->id); ?>" name="course_id">
                        <div class="col-md-12">
                            <div class="form-grp">
                                <label for=""><?php echo e(__('Rating')); ?></label>
                                <select name="rating" id="" required>
                                    <option value="5">5</option>
                                    <option value="4">4</option>
                                    <option value="3">3</option>
                                    <option value="2">2</option>
                                    <option value="1">1</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-grp">
                                <label for="phone"><?php echo e(__('Review')); ?> <code>*</code></label>
                                <textarea name="review" class="form-control" required></textarea>
                            </div>
                        </div>
                        <!-- g-recaptcha -->
                        <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
                            <div class="form-grp mt-3">
                                <div class="g-recaptcha"
                                    data-sitekey="<?php echo e(Cache::get('setting')->recaptcha_site_key); ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                        <button type="submit" class="btn arrow-btn"><?php echo e(__('Submit')); ?></button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Ask a Question')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="" class="instructor__profile-form qna-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>">
                    <div class="form-grp">
                        <label for="total_mark"><?php echo e(__('Question')); ?> <code>*</code></label>
                        <input id="total_mark" name="question" type="text" value="">
                    </div>
                    <div class="form-grp">
                        <label for="total_mark"><?php echo e(__('Description')); ?> <code>*</code></label>
                        <textarea class="text-editor-img" name="description"></textarea>
                    </div>

                    <!-- g-recaptcha -->
                    <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
                        <div class="form-grp mt-3">
                            <div class="g-recaptcha" data-sitekey="<?php echo e(Cache::get('setting')->recaptcha_site_key); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="text-end">
                        <button class="btn btn-primary" type="submit"><?php echo e(__('Submit')); ?></button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\pages\learning-player\bottom-panel.blade.php ENDPATH**/ ?>