<?php
    $mercadopagoCredentials = (object) Modules\MercadoPagoPG\app\Models\MercadoPagoPG::pluck('value', 'key')->toArray();
?>
<div class="tab-pane fade" id="mercado_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.mercadopagopg.update', 1)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <div class="form-group col-md-6">
                <label for="mercadopago_charge"><?php echo e(__('Gateway charge (%)')); ?> <span class="text-danger">*</span></label>
                <input step="0.01" type="number" class="form-control" name="mercadopago_charge"
                    id="mercadopago_charge" value="<?php echo e(@$mercadopagoCredentials?->mercadopago_charge); ?>" required="true"
                    placeholder="<?php echo e(__('Gateway charge (%)')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label><?php echo e(__('Sandbox Status')); ?> <span class="text-danger">*</span></label>
                <select name="mercadopago_sandbox" class="form-control select2" id="mercadopago_sandbox">
                    <option value=""><?php echo e(__('Select Sandbox Status')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.active_int')); ?>" <?php if(config('basicpayment.default_status.active_int') == old('mercadopago_sandbox', @$mercadopagoCredentials?->mercadopago_sandbox)): echo 'selected'; endif; ?>>
                        <?php echo e(__('Sandbox')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.inactive_int')); ?>"
                        <?php if(config('basicpayment.default_status.inactive_int') == old('mercadopago_sandbox', @$mercadopagoCredentials?->mercadopago_sandbox)): echo 'selected'; endif; ?>><?php echo e(__('Live')); ?></option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="public_key"><?php echo e(__('Public key')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="public_key" id="public_key"
                    value="<?php echo e(@$mercadopagoCredentials?->public_key); ?>" required="true"
                    placeholder="<?php echo e(__('Public key')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label for="access_token"><?php echo e(__('Access token')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="access_token" id="access_token"
                    value="<?php echo e(@$mercadopagoCredentials?->access_token); ?>" required="true"
                    placeholder="<?php echo e(__('Access token')); ?>">
            </div>
            <div class="form-group col-md-12">
                <label><?php echo e(__('New Image')); ?></label>
                <div id="image-preview-mercado" class="image-preview"
                    style="background-image: url(<?php echo e(asset(@$mercadopagoCredentials?->mercadopago_image ?? 'uploads/website-images/mercado-pago.png')); ?>);">
                    <label for="image-upload-mercado" id="image-label-mercado"><?php echo e(__('Image')); ?></label>
                    <input type="file" name="mercadopago_image" id="image-upload-mercado">
                </div>
            </div>

            <div class="form-group col-md-12">
                <label class="d-flex align-items-center">
                    <input type="hidden" value="<?php echo e(config('basicpayment.default_status.inactive_text')); ?>"
                        name="mercadopago_status" class="custom-switch-input">
                    <input type="checkbox" <?php if(config('basicpayment.default_status.active_text') ==
                            old('mercadopago_status', @$mercadopagoCredentials?->mercadopago_status)): echo 'checked'; endif; ?>
                        value="<?php echo e(config('basicpayment.default_status.active_text')); ?>" name="mercadopago_status"
                        class="custom-switch-input"
                        <?php echo e(@$mercadopagoCredentials?->mercadopago_status == 'active' ? 'checked' : ''); ?>>
                    <span class="custom-switch-indicator"></span>
                    <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
                </label>
            </div>

        </div>
        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\mercado.blade.php ENDPATH**/ ?>