<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Create currency')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.currency.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Create Currency')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.currency.index')); ?>"><?php echo e(__('Currency List')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Create Currency')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <a href="<?php echo e(route('admin.currency.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i>
                    <?php echo e(__('Currency List')); ?></a>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.currency.store')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Currency Name')); ?> <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="currency_name"
                                                value="<?php echo e(old('currency_name')); ?>">
                                        </div>
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Country Code')); ?> <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="country_code"
                                                value="<?php echo e(old('country_code')); ?>">
                                        </div>
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Currency Code')); ?> <span class="text-danger">*</span></label>
                                            <select name="currency_code" class="form-control select2">
                                                <option value=""><?php echo e(__('Select')); ?></option>
                                                <?php $__currentLoopData = $all_currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"><?php echo e($key); ?> - <?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Currency Icon')); ?> <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="currency_icon"
                                                value="<?php echo e(old('currency_icon')); ?>">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Currency Rate')); ?> <span class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="currency_rate"
                                                value="<?php echo e(old('currency_rate')); ?>">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Default')); ?> <span class="text-danger">*</span></label>
                                            <select name="is_default" class="form-control">
                                                <option value="no"><?php echo e(__('No')); ?></option>
                                                <option value="yes"><?php echo e(__('Yes')); ?></option>
                                            </select>
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Currency Position')); ?> <span class="text-danger">*</span></label>
                                            <select name="currency_position" class="form-control">
                                                <option value="before_price"><?php echo e(__('Before Price')); ?></option>
                                                <option value="before_price_with_space"><?php echo e(__('Before Price With Space')); ?>

                                                </option>
                                                <option value="after_price"><?php echo e(__('After Price')); ?></option>
                                                <option value="after_price_with_space"><?php echo e(__('After Price With Space')); ?>

                                                </option>
                                            </select>
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Status')); ?> <span class="text-danger">*</span></label>
                                            <select name="status" class="form-control">
                                                <option value="active"><?php echo e(__('Active')); ?></option>
                                                <option value="inactive"><?php echo e(__('Inactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <button class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Currency\resources\views\create.blade.php ENDPATH**/ ?>