<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Edit Profile')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Edit Profile')); ?></h1>
            </div>

            
            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card profile-widget">
                            <div class="profile-widget-header">
                                <img alt="image" id="profileImgPreview"
                                    src="<?php echo e($admin->image ? asset($admin->image) : ''); ?>"
                                    class="rounded-circle profile-widget-picture">
                            </div>

                            <div class="profile-widget-description">

                                <form <?php if(auth()->guard('admin')->user()->can('admin.profile.update')): ?> action="<?php echo e(route('admin.profile-update')); ?>"
                                    <?php endif; ?> enctype="multipart/form-data" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 400X400 PX)</code></label>
                                            <input id="profileImgInput" type="file" class="form-control-file"
                                                name="image">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Name')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" value="<?php echo e($admin->name); ?>"
                                                name="name">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Email')); ?> <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" value="<?php echo e($admin->email); ?>"
                                                name="email">
                                        </div>
                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Bio')); ?> <span class="text-danger">*</span></label>
                                            <textarea name="bio" class="form-control"><?php echo e($admin->bio); ?></textarea>
                                        </div>
                                    </div>
                                    <?php if(auth()->guard('admin')->user()->can('admin.profile.update')): ?>
                                        <div class="row">
                                            <div class="col-12">
                                                <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            

            

            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card ">
                            <div class="card-body">
                                <form <?php if(auth()->guard('admin')->user()->can('admin.profile.update')): ?> action="<?php echo e(route('admin.update-password')); ?>"
                                    <?php endif; ?> enctype="multipart/form-data" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Current Password')); ?> <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="current_password">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Password')); ?> <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="password">
                                        </div>

                                        <div class="form-group col-12">
                                            <label><?php echo e(__('Confirm Password')); ?> <span class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="password_confirmation">
                                        </div>

                                    </div>
                                    <?php if(auth()->guard('admin')->user()->can('admin.profile.update')): ?>
                                        <div class="row">
                                            <div class="col-12">
                                                <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            

        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        //input image preview function
        "use strict";
        function setupImagePreview(inputSelector, imageElementId) {
            $(document).on("input", "#" + inputSelector, function() {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $("#" + imageElementId).attr("src", e.target.result);
                };
                reader.readAsDataURL(this.files[0]);
            });
        }

        $(document).ready(function() {
            setupImagePreview('profileImgInput', 'profileImgPreview');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\profile\edit_profile.blade.php ENDPATH**/ ?>