<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img class="admin_logo" src="<?php echo e(asset($setting->logo) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <div class="sidebar-brand sidebar-brand-sm">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img src="<?php echo e(asset($setting->favicon) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <ul class="sidebar-menu">
            <?php if(auth()->guard('admin')->user()->can('dashboard.view')): ?>
                <li class="<?php echo e(isRoute('admin.dashboard', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>"><i class="fas fa-home"></i>
                        <span><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('course.management') || checkAdminHasPermission('course.certificate.management') || checkAdminHasPermission('badge.management') || checkAdminHasPermission('blog.view')): ?>
                <li class="menu-header"><?php echo e(__('Manage Contents')); ?></li>

                <?php if(Module::isEnabled('Course') && checkAdminHasPermission('course.management')): ?>
                    <?php echo $__env->make('course::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('CertificateBuilder') && checkAdminHasPermission('course.certificate.management')): ?>
                    <?php echo $__env->make('certificatebuilder::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Badges') && checkAdminHasPermission('badge.management')): ?>
                    <?php echo $__env->make('badges::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Blog')): ?>
                    <?php echo $__env->make('blog::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('order.management') || checkAdminHasPermission('coupon.management') || checkAdminHasPermission('withdraw.management')): ?>
                <li class="menu-header"><?php echo e(__('Manage Orders')); ?></li>

                <?php if(Module::isEnabled('Order') && checkAdminHasPermission('order.management')): ?>
                    <?php echo $__env->make('order::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Coupon') && checkAdminHasPermission('coupon.management')): ?>
                    <?php echo $__env->make('coupon::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('PaymentWithdraw') && checkAdminHasPermission('withdraw.management')): ?>
                    <?php echo $__env->make('paymentwithdraw::admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('instructor.request.list') || checkAdminHasPermission('customer.view') || checkAdminHasPermission('location.view')): ?>
                <li class="menu-header"><?php echo e(__('Manage Users')); ?></li>
                <?php if(
                    (Module::isEnabled('InstructorRequest') && checkAdminHasPermission('instructor.request.list')) ||
                        checkAdminHasPermission('instructor.request.setting')): ?>
                    <?php echo $__env->make('instructorrequest::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Customer') && checkAdminHasPermission('customer.view')): ?>
                    <?php echo $__env->make('customer::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Location') && checkAdminHasPermission('location.view')): ?>
                    <?php echo $__env->make('location::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('appearance.management') || checkAdminHasPermission('section.management') || checkAdminHasPermission('footer.management') || checkAdminHasPermission('brand.managemen')): ?>
                <li class="menu-header"><?php echo e(__('Site Contents')); ?></li>
                <?php if(Module::isEnabled('SiteAppearance') && checkAdminHasPermission('appearance.management')): ?>
                    <?php echo $__env->make('siteappearance::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Frontend') && checkAdminHasPermission('section.management')): ?>
                    <?php echo $__env->make('frontend::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Brand') && checkAdminHasPermission('brand.management')): ?>
                    <?php echo $__env->make('brand::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('FooterSetting') && checkAdminHasPermission('footer.management')): ?>
                    <?php echo $__env->make('footersetting::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>


            <?php if(checkAdminHasPermission('menu.view') || checkAdminHasPermission('page.management') || checkAdminHasPermission('social.link.management') || checkAdminHasPermission('faq.view')): ?>
                <li class="menu-header"><?php echo e(__('Manage Website')); ?></li>

                <?php if(Module::isEnabled('MenuBuilder') && checkAdminHasPermission('menu.view')): ?>
                    <?php echo $__env->make('menubuilder::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                
                <?php if(Module::isEnabled('PageBuilder') && checkAdminHasPermission('page.management')): ?>
                    <?php echo $__env->make('pagebuilder::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('SocialLink') && checkAdminHasPermission('social.link.management')): ?>
                    <?php echo $__env->make('sociallink::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Faq') && checkAdminHasPermission('faq.view')): ?>
                    <?php echo $__env->make('faq::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('setting.view') || checkAdminHasPermission('basic.payment.view') || checkAdminHasPermission('payment.view') || checkAdminHasPermission('currency.view') || checkAdminHasPermission('role.view') || checkAdminHasPermission('admin.view') || checkAdminHasPermission('addon.view')): ?>
                <li class="menu-header"><?php echo e(__('Settings')); ?></li>
                <li class="<?php echo e(isRoute('admin.settings', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.settings')); ?>"><i class="fas fa-cog"></i>
                        <span><?php echo e(__('Settings')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('newsletter.view') || checkAdminHasPermission('testimonial.view') || checkAdminHasPermission('contect.message.view')): ?>
                <li class="menu-header"><?php echo e(__('Utility')); ?></li>

                <?php if(Module::isEnabled('NewsLetter') && checkAdminHasPermission('newsletter.view')): ?>
                    <?php echo $__env->make('newsletter::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Testimonial') && checkAdminHasPermission('testimonial.view')): ?>
                    <?php echo $__env->make('testimonial::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('ContactMessage') && checkAdminHasPermission('contect.message.view')): ?>
                    <?php echo $__env->make('contactmessage::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>
            <li class="nav-item dropdown <?php echo e(isRoute('admin.addon.*') ? 'active' : ''); ?>" id="addon_sidemenu">
                <a class="nav-link has-dropdown" data-toggle="dropdown" href="#"><i class="fas fa-gem"></i>
                    <span><?php echo e(__('Manage Addons')); ?> </span>
                </a>
                <ul class="dropdown-menu addon_menu">
                    <?php if ($__env->exists('admin.addons')) echo $__env->make('admin.addons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            </li>
        </ul>
        <div class="py-3 text-center">
            <div class="btn-sm-group-vertical version_button" role="group" aria-label="Responsive button group">
                <button class="btn btn-primary logout_btn mt-2" disabled><?php echo e(__('version')); ?>

                    <?php echo e($setting->version ?? '1.0.0'); ?></button>
                <button class="btn btn-danger mt-2"
                    onclick="event.preventDefault(); $('#admin-logout-form').trigger('submit');"><i
                        class="fas fa-sign-out-alt"></i></button>
            </div>
        </div>
    </aside>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\sidebar.blade.php ENDPATH**/ ?>