<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap dashboard__content-wrap-two">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Earnings')); ?></h4>
        </div>

        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count" data-count=""><?php echo e(currency(userAuth()->wallet_balance)); ?></span>
                        <p><?php echo e(__('Current Balance')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count"><?php echo e($totalCourseSold); ?></span>
                        <p><?php echo e(__('Courses Sold')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count"><?php echo e(currency($totalWithdraw)); ?></span>
                        <p><?php echo e(__('Total Payout')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard__content-wrap mt-3">
        <div class="dashboard__content-title d-flex flex-wrap justify-content-between">
            <h4 class="title"><?php echo e(__('Payout History')); ?></h4>
            <a href="<?php echo e(route('instructor.payout.create')); ?>" class="btn btn-primary btn-hight-basic">
                <?php echo e(__('Request Payout')); ?>

            </a>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Withdraw Amount')); ?></th>
                                <th><?php echo e(__('Method')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $withdrawRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $withdrawRequest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <p><?php echo e($loop->iteration); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e(currency($withdrawRequest->withdraw_amount)); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($withdrawRequest->method); ?></p>
                                    </td>
                                    <td>
                                        <?php if($withdrawRequest->status == 'approved'): ?>
                                            <span class="badge bg-success"><?php echo e(__('Approved')); ?></span>
                                        <?php elseif($withdrawRequest->status == 'rejected'): ?>
                                            <span class="badge bg-danger"><?php echo e(__('Rejected')); ?></span>
                                        <?php elseif($withdrawRequest->status == 'pending'): ?>
                                            <span class="badge bg-warning"><?php echo e(__('Pending')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <p><?php echo e(formatDate($withdrawRequest->created_at)); ?></p>
                                    </td>

                                    <td>
                                        <?php if($withdrawRequest->status == 'pending'): ?>
                                            <p><a href="<?php echo e(route('instructor.payout.destroy', $withdrawRequest->id)); ?>"
                                                    class="text-danger delete-item"><i class="fas fa-trash-alt"></i></a></p>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td class="text-center" colspan="100"><?php echo e(__('No Data')); ?></td>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\payout\index.blade.php ENDPATH**/ ?>