<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo e(__('Learnings')); ?> | <?php echo e(Cache::get('setting')?->app_name); ?></title>
    <meta name="description" content="SkillGro - Online Courses & Education Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="course-id" content="<?php echo e(@$course->id); ?>">
    <meta name="lesson-id" content="">
    <meta name="question-id" content="">

    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset(Cache::get('setting')?->favicon)); ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/video_player.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/spacing.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/tg-cursor.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/main.min.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/frontend.min.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <style>
        :root {
            --tg-theme-primary: <?php echo e($setting->primary_color); ?>;
            --tg-theme-secondary: <?php echo e($setting->secondary_color); ?>;
            --tg-common-color-blue: <?php echo e($setting->common_color_one); ?>;
            --tg-common-color-blue-2: <?php echo e($setting->common_color_two); ?>;
            --tg-common-color-dark: <?php echo e($setting->common_color_three); ?>;
            --tg-common-color-black: <?php echo e($setting->common_color_four); ?>;
            --tg-common-color-dark-2: <?php echo e($setting->common_color_five); ?>;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>


    <?php echo $__env->yieldContent('contents'); ?>


    <!-- JS here -->
    <script>
        "use strict";
        var base_url = "<?php echo e(url('/')); ?>";
        var resource_text = "<?php echo e(__('Resource')); ?>";
        var download_des_text = "<?php echo e(__('Click on the download button for download the file')); ?>";
        var download_btn_text = "<?php echo e(__('Download')); ?>";
        var file_type_text = "<?php echo e(__('File Type')); ?>";
        var le_hea = "<?php echo e(__('Lesson is started')); ?>";
        var le_des = "<?php echo e(__('This lesson has now started. The lesson will end on')); ?>";
        var le_fi_he = "<?php echo e(__('Lesson is finished')); ?>";
        var le_fi_des = "<?php echo e(__('This lesson is finished. You cant join it.')); ?>";
        var le_wi_he = "<?php echo e(__('Lesson is not started yet')); ?>";
        var le_wi_des = "<?php echo e(__('This lesson will be started on')); ?>";
        var open_w_txt = "<?php echo e(__('Open in Website')); ?>";
        var cre_mi_txt = "<?php echo e(__('credential missing')); ?>";
        var open_des_txt = "<?php echo e(__('Click on the open button for check out the file')); ?>";
        var open_txt = "<?php echo e(__('Open')); ?>";
        var quiz_st_des_txt = "<?php echo e(__('Please go to quiz page for mor information')); ?>";
        var quiz_st_txt = "<?php echo e(__('Start Quiz')); ?>";
        var no_des_txt = "<?php echo e(__('No description')); ?>";
    </script>
    
    <script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/tg-cursor.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/jquery.magnific-popup.min.js')); ?>"></script>

    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/sweetalert.js')); ?>"></script>

    <script src="<?php echo e(asset('frontend/js/tinymce/js/tinymce/tinymce.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/video_player.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/video_player_youtube.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/js/videojs-vimeo.js')); ?>"></script>
    <script>
        "use strict";
        toastr.options.closeButton = true;
        toastr.options.progressBar = true;
        toastr.options.positionClass = 'toast-bottom-right';
        <?php $__sessionArgs = ['message'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
        var type = "<?php echo e(Session::get('alert-type', 'info')); ?>"
        switch (type) {
            case 'info':
                toastr.info("<?php echo e($value); ?>");
                break;
            case 'success':
                toastr.success("<?php echo e($value); ?>");
                break;
            case 'warning':
                toastr.warning("<?php echo e($value); ?>");
                break;
            case 'error':
                toastr.error("<?php echo e($value); ?>");
                break;
        }
        <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>

        tinymce.init({
            selector: ".text-editor",
            plugins: ["link"],
            toolbar: "bold italic | formats | link",
            toolbar_mode: "floating",
            toolbar_sticky: true,
            menubar: false,
            contextmenu: "link openlink",
        });
    </script>
    <!-- Google reCAPTCHA -->
    <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\pages\learning-player\master.blade.php ENDPATH**/ ?>