<div class="tab-pane fade" id="paystack_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.paystack-update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Gateway charge (%)')); ?></label>
                <input type="text" class="form-control" name="paystack_charge"
                    value="<?php echo e($payment_setting->paystack_charge); ?>">
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Public key')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="paystack_public_key"
                        value="paystack-test-348949439-public-key">
                <?php else: ?>
                    <input type="text" class="form-control" name="paystack_public_key"
                        value="<?php echo e($payment_setting->paystack_public_key); ?>">
                <?php endif; ?>
            </div>

            <div class="form-group col-md-12">
                <label for=""><?php echo e(__('Secret key')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="paystack_secret_key"
                        value="demo-paystack-8384934-key-secret">
                <?php else: ?>
                    <input type="text" class="form-control" name="paystack_secret_key"
                        value="<?php echo e($payment_setting->paystack_secret_key); ?>">
                <?php endif; ?>
            </div>

        </div>

        
        <div class="form-group">
            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 210X100 PX)</code></label>
            <div id="image-preview-paystack" class="image-preview">
                <label for="image-upload-paystack"
                    id="image-label-paystack"><?php echo e(__('Image')); ?></label>
                <input type="file" name="paystack_image" id="image-upload-paystack">
            </div>
        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="paystack_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="paystack_status" class="custom-switch-input"
                    <?php echo e($payment_setting?->paystack_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\paystack.blade.php ENDPATH**/ ?>