<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Site Color Settings')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap-colorpicker.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Site Color Settings')); ?></h1>
            </div>

            <div class="section-body">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.site-color-setting.update', 1)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Primary Color')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" name="primary_color" class="form-control" value="<?php echo e(@Cache::get('setting')?->primary_color); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><?php echo e(__('Secondary Color')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="secondary_color" value="<?php echo e(@Cache::get('setting')?->secondary_color); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('Common Color One')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="common_color_one" value="<?php echo e(@Cache::get('setting')?->common_color_one); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('Common Color Two')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="common_color_two" value="<?php echo e(@Cache::get('setting')?->common_color_two); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('Common Color Three')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="common_color_three" value="<?php echo e(@Cache::get('setting')?->common_color_three); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('Common Color Four')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="common_color_four" value="<?php echo e(@Cache::get('setting')?->common_color_four); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('Common Color Five')); ?></label>
                                        <div class="input-group colorpickerinput colorpicker-element"
                                            data-colorpicker-id="2">
                                            <input type="text" class="form-control" name="common_color_five" value="<?php echo e(@Cache::get('setting')?->common_color_five); ?>">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <i class="fas fa-fill-drip"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/bootstrap-colorpicker.min.js')); ?>"></script>
    <script>
        $(".colorpickerinput").colorpicker({
            format: 'hex',
            component: '.input-group-append',
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\SiteAppearance\resources\views\site-color\index.blade.php ENDPATH**/ ?>