<div class="dashboard__sidebar-wrap">
    <div class="dashboard__sidebar-title mb-20">
        <h6 class="title"><?php echo e(__('Welcome')); ?>, <?php echo e(userAuth()->name); ?></h6>
    </div>
    <nav class="dashboard__sidebar-menu">
        <ul class="list-wrap">
            
            <li class="<?php echo e(Route::is('student.dashboard') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.dashboard')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/dashboard.svg')); ?>">
                    <?php echo e(__('Dashboard')); ?>

                </a>
            </li>

            <li class="<?php echo e(Route::is('student.orders.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.orders.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/order-history.svg')); ?>">
                    <?php echo e(__('Order History')); ?>

                </a>
            </li>

            <li class="<?php echo e(Route::is('student.enrolled-courses') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.enrolled-courses')); ?>">
                    <i class="flaticon-mortarboard"></i><?php echo e(__('Enrolled Courses')); ?></a>
            </li>
            <li class="<?php echo e(Route::is('student.wishlist') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.wishlist')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/heart.svg')); ?>"><?php echo e(__('Wishlist')); ?></a>
            </li>
            <li class="<?php echo e(Route::is('student.reviews.index') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.reviews.index')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/reviews.svg')); ?>"><?php echo e(__('Reviews')); ?></a>
            </li>
            <li class="<?php echo e(Route::is('student.quiz-attempts') ? 'active' : ''); ?>">
                <a href="<?php echo e(route('student.quiz-attempts')); ?>">
                    <img src="<?php echo e(asset('uploads/website-images/quiz.svg')); ?>"><?php echo e(__('My Quiz Attempts')); ?></a>
            </li>
        </ul>
    </nav>
    <div class="dashboard__sidebar-title mt-30 mb-20">
        <h6 class="title"><?php echo e(__('User')); ?></h6>
    </div>
    <nav class="dashboard__sidebar-menu">
        <ul class="list-wrap">
            <li>
                <a href="<?php echo e(route('student.setting.index')); ?>">
                    <i class="flaticon-user"></i>
                    <?php echo e(__('Profile Settings')); ?>

                </a>
            </li>
            <li>
                <a href="<?php echo e(route('logout')); ?>"
                    onclick="event.preventDefault(); $('#logout-form').trigger('submit');">
                    <img src="<?php echo e(asset('uploads/website-images/logout.svg')); ?>">
                    <?php echo e(__('Logout')); ?>

                </a>
            </li>
        </ul>
    </nav>
</div>


<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
    <?php echo csrf_field(); ?>
</form>

<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\layouts\sidebar.blade.php ENDPATH**/ ?>