<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Create')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Course')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Course Create')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="card">
                    <div class="card-body">
                        <div class="col-12">
                            <?php echo $__env->make('course::course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="instructor__profile-form-wrap mt-4">
                                <form action="<?php echo e(route('admin.courses.update')); ?>" class="instructor__profile-form course-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="course_id" id="" value="<?php echo e($course->id); ?>">
                                    <input type="hidden" name="step" id="" value="5">
                                    <input type="hidden" name="next_step" value="5">

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Message for Reviewer')); ?> <code></code></label>
                                                <textarea name="message_for_reviewer" class="form-control"><?php echo e($course->message_for_reviewer); ?></textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                          <div class="form-group">
                                              <label for=""><?php echo e(__('Status')); ?> <code>*</code></label>
                                              <select name="status" id="" class="form-control">
                                                <option value=""><?php echo e(__('Select')); ?></option>
                                                <option <?php if($course->status == 'active'): echo 'selected'; endif; ?> value="active"><?php echo e(__('Publish')); ?></option>
                                                <option <?php if($course->status == 'inactive'): echo 'selected'; endif; ?> value="inactive"><?php echo e(__('UnPublish')); ?></option>
                                                <option <?php if($course->status == 'is_draft'): echo 'selected'; endif; ?> value="is_draft"><?php echo e(__('Draft')); ?></option>
                                              </select>
                                          </div>
                                      </div>

                                        <div class="col-md-12">
                                            <button class="btn btn-primary" type="submit"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course\finish.blade.php ENDPATH**/ ?>