<?php $__env->startSection('title'); ?>
    <title><?php echo e($title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e($title); ?></h1>

            </div>

            <div class="section-body">
                <div class="row mt-4">
                    
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(url()->current()); ?>" method="GET" onchange="$(this).trigger('submit')"
                                    class="form_padding">
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <input type="text" name="keyword" value="<?php echo e(request()->get('keyword')); ?>"
                                                class="form-control" placeholder="<?php echo e(__('Search')); ?>">
                                        </div>
                                        <?php if(Route::is('admin.withdraw-list')): ?>
                                            <div class="col-md-2 form-group">
                                                <select name="status" id="status" class="form-control">
                                                    <option value=""><?php echo e(__('Select Status')); ?></option>
                                                    <option value="pending"
                                                        <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Pending')); ?>

                                                    </option>
                                                    <option value="approved"
                                                        <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Approved')); ?>

                                                    </option>
                                                    <option value="rejected"
                                                        <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Rejected')); ?>

                                                    </option>
                                                </select>
                                            </div>
                                        <?php endif; ?>

                                        <div class="col-md-2 form-group">
                                            <select name="order_by" id="order_by" class="form-control">
                                                <option value=""><?php echo e(__('Order By')); ?></option>
                                                <option value="1" <?php echo e(request('order_by') == '1' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('ASC')); ?>

                                                </option>
                                                <option value="0" <?php echo e(request('order_by') == '0' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('DESC')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-2 form-group">
                                            <select name="par-page" id="par-page" class="form-control">
                                                <option value=""><?php echo e(__('Per Page')); ?></option>
                                                <option value="10" <?php echo e('10' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('10')); ?>

                                                </option>
                                                <option value="50" <?php echo e('50' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('50')); ?>

                                                </option>
                                                <option value="100"
                                                    <?php echo e('100' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('100')); ?>

                                                </option>
                                                <option value="all"
                                                    <?php echo e('all' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('All')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive table-invoice">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th><?php echo e(__('User')); ?></th>
                                                <th><?php echo e(__('Method')); ?></th>
                                                <th><?php echo e(__('Current Balance')); ?></th>
                                                <th><?php echo e(__('Withdraw Amount')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th><?php echo e(__('Date')); ?></th>
                                                <th><?php echo e(__('Action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e(++$index); ?></td>
                                                    <td><a
                                                            href="<?php echo e(route('admin.customer-show', $withdraw->user_id)); ?>"><?php echo e($withdraw?->user?->name); ?></a>
                                                    </td>

                                                    <td><?php echo e($withdraw->method); ?></td>
                                                    <td>
                                                        <?php echo e(currency($withdraw->current_amount)); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e(currency($withdraw->withdraw_amount)); ?>

                                                    </td>
                                                    <td>
                                                        <?php if($withdraw->status == 'approved'): ?>
                                                            <span class="badge badge-success"><?php echo e(__('Success')); ?></span>
                                                        <?php elseif($withdraw->status == 'rejected'): ?>
                                                            <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-warning"><?php echo e(__('Pending')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e(formatDate($withdraw->created_at)); ?>

                                                    </td>
                                                    <td>

                                                        <a href="<?php echo e(route('admin.show-withdraw', $withdraw->id)); ?>"
                                                            class="btn btn-primary btn-sm"><i class="fa fa-eye"
                                                                aria-hidden="true"></i></a>

                                                    </td>


                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __(''),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '8'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php if(request()->get('par-page') !== 'all'): ?>
                                    <div class="float-right">
                                        <?php echo e($withdraws->onEachSide(0)->links()); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>

    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
    <script>
        "use strict"

        function deleteData(id) {
            $("#deleteForm").attr("action", '<?php echo e(url('admin/delete-withdraw/')); ?>' + "/" + id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\PaymentWithdraw\resources\views\admin\index.blade.php ENDPATH**/ ?>