<?php use \App\Enums\ThemeList; ?>
<?php if(Module::isEnabled('Language') && Route::has('admin.blogs.index')): ?>
    <li
        class="nav-item dropdown <?php echo e(isRoute(
            [
                'admin.hero-section.*',
                'admin.about-section.*',
                'admin.featured-course-section.*',
                'admin.counter-section.*',
                'admin.faq-section.*',
                'admin.our-features-section.*',
                'admin.banner-section.*',
                'admin.contact-section.*',
                'admin.newsletter-section.*',
                'admin.featured-instructor-section.*',
            ],
            'active',
        )); ?>">
        <a href="javascript:void()" class="nav-link has-dropdown"><i
                class="fas fa-puzzle-piece"></i><span><?php echo e(__('Sections')); ?></span></a>

        <ul class="dropdown-menu">
            <?php if(DEFAULT_HOMEPAGE != ThemeList::BUSINESS->value): ?>
                <li class="<?php echo e(isRoute('admin.hero-section.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.hero-section.index', ['code' => 'en'])); ?>">
                        <?php echo e(__('Hero Section')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <?php if(in_array(DEFAULT_HOMEPAGE, [ThemeList::BUSINESS->value])): ?>
                <li class="<?php echo e(isRoute('admin.slider-section.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.slider-section.index', ['code' => 'en'])); ?>">
                        <?php echo e(__('Slider Section')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <li class="<?php echo e(isRoute('admin.about-section.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.about-section.index', ['code' => 'en'])); ?>">
                    <?php echo e(__('About Section')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.featured-course-section.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.featured-course-section.index')); ?>">
                    <?php echo e(__('Featured Course Section')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.newsletter-section.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.newsletter-section.index')); ?>">
                    <?php echo e(__('Newsletter Section')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.featured-instructor-section.*', 'active')); ?>">
                <a class="nav-link"
                    href="<?php echo e(route('admin.featured-instructor-section.edit', ['featured_instructor_section' => 1, 'code' => 'en'])); ?>">
                    <?php echo e(__('Featured Instructor')); ?>

                </a>
            </li>
            <?php if(in_array(DEFAULT_HOMEPAGE, [ThemeList::MAIN->value, ThemeList::ONLINE->value, ThemeList::UNIVERSITY->value,ThemeList::LANGUAGE->value])): ?>
                <li class="<?php echo e(isRoute('admin.counter-section.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.counter-section.index', ['code' => 'en'])); ?>">
                        <?php echo e(__('Counter Section')); ?>

                    </a>
                </li>
            <?php endif; ?>
                <li class="<?php echo e(isRoute('admin.faq-section.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.faq-section.index', ['code' => 'en'])); ?>">
                        <?php echo e(__('Faq Section')); ?>

                    </a>
                </li>

            <li class="<?php echo e(isRoute('admin.our-features-section.*', 'active')); ?>">
                <a class="nav-link"
                    href="<?php echo e(route('admin.our-features-section.index', ['code' => 'en'])); ?>">
                    <?php echo e(__('Our Features Section')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.banner-section.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.banner-section.index')); ?>">
                    <?php echo e(__('Banner Section')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.contact-section.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.contact-section.index')); ?>">
                    <?php echo e(__('Contact Page Section')); ?>

                </a>
            </li>
        </ul>
    </li>
<?php endif; ?>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\Frontend\resources\views\sidebar.blade.php ENDPATH**/ ?>