<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Order History')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Invoice')); ?></th>
                                <th><?php echo e(__('Paid')); ?></th>
                                <th><?php echo e(__('Gateway')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Payment')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(++$index); ?></td>
                                    <td>#<?php echo e($order->invoice_id); ?></td>
                                    <td><?php echo e($order->paid_amount); ?> <?php echo e($order->payable_currency); ?></td>
                                    <td>
                                        <?php echo e($order->payment_method); ?>

                                    </td>
                                    <td>
                                        <?php if($order->status == 'completed'): ?>
                                            <div class="badge bg-success"><?php echo e(__('Completed')); ?></div>
                                        <?php elseif($order->status == 'processing'): ?>
                                            <div class="badge bg-warning"><?php echo e(__('Processing')); ?></div>
                                        <?php elseif($order->status == 'declined'): ?>
                                            <div class="badge bg-danger"><?php echo e(__('Declined')); ?></div>
                                        <?php else: ?>
                                            <div class="badge bg-warning"><?php echo e(__('Pending')); ?></div>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if($order->payment_status == 'paid'): ?>
                                            <div class="badge bg-success"><?php echo e(__('Paid')); ?></div>
                                        <?php elseif($order->payment_status == 'cancelled'): ?>
                                            <div class="badge bg-danger"><?php echo e(__('Cancelled')); ?></div>
                                        <?php else: ?>
                                            <div class="badge bg-danger"><?php echo e(__('Pending')); ?></div>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('student.order.show', $order->id)); ?>" class=""><i
                                                class="fa fa-eye"></i></a>
                                        <?php if($order->status == 'pending'): ?>
                                            <a target="_blank"
                                                href="<?php echo e(route('payment', ['invoice_id' => $order->invoice_id])); ?>"
                                                class="bg-info"><i class="fa fa-credit-card"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="10" class="text-center"><?php echo e(__('No orders found!')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($orders->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\order\index.blade.php ENDPATH**/ ?>