<?php $__env->startSection('custom_meta'); ?>
    <meta name="course_id" content="<?php echo e(request('id')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Create')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    
    <form action="<?php echo e(route('admin.courses.update')); ?>" class="instructor__profile-form course-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="step" value="3">
        <input type="hidden" name="next_step" value="4">
    </form>
    <?php echo $__env->make('course::course.partials.add-new-section-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-content">

        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Course')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Course Create')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="col-12">
                    <?php echo $__env->make('course::course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="instructor__profile-form-wrap mt-4">
                                <form action="">
                                    <?php echo csrf_field(); ?>
                                    <div class="mb-3 d-flex justify-content-between">
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                            data-target="#exampleModal">
                                            <?php echo e(__('Add new chapter')); ?>

                                        </button>

                                        <button type="button" class="btn btn-primary sort-chapter-btn">
                                            <?php echo e(__('Sort chapter')); ?>

                                        </button>

                                    </div>
                                    <div class="accordion draggable-list" id="accordion">
                                        <?php $__empty_1 = true; $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="accordion-item course-section add_course_section_area">
                                                <h2 class="accordion-header" id="panelsStayOpen-heading<?php echo e($chapter->id); ?>">
                                                    <div
                                                        class="accordion_header_content d-flex flex-wrap justify-content-between">
                                                        <button class="accordion-button course-section-btn collapsed"
                                                            type="button" data-toggle="collapse"
                                                            data-target="#panelsStayOpen-collapse<?php echo e($chapter->id); ?>"
                                                            aria-expanded="true"
                                                            aria-controls="panelsStayOpen-collapse<?php echo e($chapter->id); ?>">
                                                            <div
                                                                class="icon_area d-flex flex-wrap justify-content-between align-items-center w-100">
                                                                <div class="d-flex flex-wrap  align-items-center">
                                                                    <span class="icon-container"><i
                                                                            class="far fa-folder"></i></span>
                                                                    <p class="mb-0 ms-2 bold-text"><?php echo e($chapter->title); ?>

                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </button>

                                                        <div class="item-action item_action_header d-flex flex-wrap">
                                                            <div class="dropdown action-item">
                                                                <span class="dropdown-toggle btn btn-small small-more-btn"
                                                                    data-toggle="dropdown" aria-expanded="false">
                                                                    <i class="fas fa-plus"></i>
                                                                </span>
                                                                <ul class="dropdown-menu dropdown-menu-end">
                                                                    <li><a class="dropdown-item add-lesson-btn"
                                                                            data-type="lesson"
                                                                            data-chapterid="<?php echo e($chapter->id); ?>"
                                                                            href="javascript:;"><?php echo e(__('Add Lesson')); ?></a>
                                                                    </li>
                                                                    <li><a class="dropdown-item add-lesson-btn"
                                                                            data-type="document"
                                                                            data-chapterid="<?php echo e($chapter->id); ?>"
                                                                            href="javascript:;"><?php echo e(__('Add Document')); ?></a>
                                                                    </li>
                                                                    <li><a class="dropdown-item add-lesson-btn"
                                                                            data-type="quiz"
                                                                            data-chapterid="<?php echo e($chapter->id); ?>"
                                                                            href="javascript:;"><?php echo e(__('Add Quiz')); ?></a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <a href="javascript:;"
                                                                class="text-dark action-item edit-chapter-btn"
                                                                data-chapterid="<?php echo e($chapter->id); ?>"><i
                                                                    class="fas fa-edit"></i></a>
                                                            <a href="<?php echo e(route('admin.course-chapter.destroy', $chapter->id)); ?>"
                                                                class="text-danger action-item delete-item"><i
                                                                    class="fas fa-trash-alt"></i></a>
                                                        </div>
                                                    </div>
                                                </h2>
                                                <div id="panelsStayOpen-collapse<?php echo e($chapter->id); ?>"
                                                    class="accordion-collapse collapse <?php echo e($loop->first ? 'show' : ''); ?>"
                                                    aria-labelledby="panelsStayOpen-heading<?php echo e($chapter->id); ?>">
                                                    <div class="accordion-body">
                                                        <?php $__empty_2 = true; $__currentLoopData = $chapter->chapterItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapterItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                            <?php if($chapterItem->type == 'lesson'): ?>
                                                                <div class="card course-section-item create_couese_item mb-3"
                                                                    data-chapter-item-id="<?php echo e($chapterItem->id); ?>"
                                                                    data-chapterid="<?php echo e($chapter->id); ?>">
                                                                    <div
                                                                        class="d-flex flex-wrap justify-content-between align-items-center">
                                                                        <div
                                                                            class="edit_course_icons d-flex flex-wrap align-items-center">
                                                                            <span class="icon-container"><i
                                                                                    class="fas fa-video"></i></span>
                                                                            <p class="mb-0 ms-2 bold-text">
                                                                                <?php echo e(truncate($chapterItem->lesson->title)); ?>

                                                                            </p>
                                                                        </div>
                                                                        <div class="item-action">
                                                                            <a href="javascript:;"
                                                                                class="ms-2 text-dark edit-lesson-btn"
                                                                                data-type="<?php echo e($chapterItem->type); ?>"
                                                                                data-courseid="<?php echo e($chapter->course_id); ?>"
                                                                                data-chapterid="<?php echo e($chapter->id); ?>"
                                                                                data-chapter_item_id="<?php echo e($chapterItem->id); ?>"><i
                                                                                    class="fas fa-edit"></i></a>
                                                                            <a href="<?php echo e(route('admin.course-chapter.lesson.destroy', $chapterItem->id)); ?>"
                                                                                class="ms-2 text-danger delete-item"><i
                                                                                    class="fas fa-trash-alt"></i></i></a>
                                                                            <a href="javascript:;" class="ms-2 dragger"><i
                                                                                    class="fas fa-arrows-alt"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php elseif($chapterItem->type == 'document'): ?>
                                                                <div class="card course-section-item create_couese_item mb-3"
                                                                    data-chapter-item-id="<?php echo e($chapterItem->id); ?>"
                                                                    data-chapterid="<?php echo e($chapter->id); ?>">
                                                                    <div
                                                                        class="d-flex flex-wrap justify-content-between align-items-center">
                                                                        <div
                                                                            class="edit_course_icons d-flex flex-wrap align-items-center">
                                                                            <span class="icon-container"><i
                                                                                    class="fas fa-file-pdf"></i></span>
                                                                            <p class="mb-0 ms-2 bold-text">
                                                                                <?php echo e(truncate($chapterItem->lesson?->title)); ?>

                                                                            </p>
                                                                        </div>
                                                                        <div class="item-action">
                                                                            <a href="javascript:;"
                                                                                class="ms-2 text-dark edit-lesson-btn"
                                                                                data-type="<?php echo e($chapterItem->type); ?>"
                                                                                data-courseid="<?php echo e($chapter->course_id); ?>"
                                                                                data-chapterid="<?php echo e($chapter->id); ?>"
                                                                                data-chapter_item_id="<?php echo e($chapterItem->id); ?>"><i
                                                                                    class="fas fa-edit"></i></a>
                                                                            <a href="<?php echo e(route('admin.course-chapter.lesson.destroy', $chapterItem->id)); ?>"
                                                                                class="ms-2 text-danger delete-item"><i
                                                                                    class="fas fa-trash-alt"></i></i></a>
                                                                            <a href="javascript:;" class="ms-2 dragger"><i
                                                                                    class="fas fa-arrows-alt"></i></a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php elseif($chapterItem->type == 'quiz'): ?>
                                                                <div class="accordion card mb-2" id="accordionExample"
                                                                    data-chapter-item-id="<?php echo e($chapterItem->id); ?>"
                                                                    data-chapterid="<?php echo e($chapter->id); ?>">
                                                                    <div class="accordion-item">
                                                                        <h2 class="accordion-header">
                                                                            <div
                                                                                class="accordion_header_content d-flex flex-wrap justify-content-between">
                                                                                <button
                                                                                    class="accordion-button course-quiz-btn collapsed"
                                                                                    type="button" data-toggle="collapse"
                                                                                    data-target="#panelsStayOpen-collapse<?php echo e($chapterItem->id); ?>"
                                                                                    aria-expanded="true"
                                                                                    aria-controls="panelsStayOpen-collapse<?php echo e($chapterItem->id); ?>">
                                                                                    <div
                                                                                        class="d-flex flex-wrap justify-content-between align-items-center w-100">
                                                                                        <div
                                                                                            class="d-flex flex-wrap align-items-center">
                                                                                            <span class="icon-container"><i
                                                                                                    class="fas fa-question"></i></span>
                                                                                            <p class="mb-0 ms-2 bold-text">
                                                                                                <?php echo e($chapterItem->quiz->title); ?>

                                                                                            </p>
                                                                                        </div>
                                                                                    </div>
                                                                                </button>
                                                                                <div
                                                                                    class="item-action course_quiz_item_action d-flex">
                                                                                    <div class="dropdown action-item">
                                                                                        <span
                                                                                            class="dropdown-toggle btn btn-small small-more-btn"
                                                                                            data-toggle="dropdown"
                                                                                            aria-expanded="false">
                                                                                            <i class="fas fa-plus"></i>
                                                                                        </span>
                                                                                        <ul
                                                                                            class="dropdown-menu dropdown-menu-end">
                                                                                            <li><a class="dropdown-item add-quiz-question-btn"
                                                                                                    data-quiz-id="<?php echo e($chapterItem->quiz->id); ?>"
                                                                                                    href="javascript:;"><?php echo e(__('Add Question')); ?></a>
                                                                                            </li>
                                                                                        </ul>
                                                                                    </div>
                                                                                    <a href="javascript:;"
                                                                                        data-type="<?php echo e($chapterItem->type); ?>"
                                                                                        data-courseid="<?php echo e($chapter->course_id); ?>"
                                                                                        data-chapterid="<?php echo e($chapter->id); ?>"
                                                                                        data-chapter_item_id="<?php echo e($chapterItem->id); ?>"
                                                                                        class="text-dark action-item edit-lesson-btn"><i
                                                                                            class="fas fa-edit"></i></a>
                                                                                    <a href="<?php echo e(route('admin.course-chapter.lesson.destroy', $chapterItem->id)); ?>"
                                                                                        class="text-danger action-item delete-item"><i
                                                                                            class="fas fa-trash-alt"></i></a>
                                                                                    <a href="javascript:;"
                                                                                        class="ms-2 dragger"><i
                                                                                            class="fas fa-arrows-alt"></i></a>
                                                                                </div>
                                                                            </div>
                                                                        </h2>
                                                                        <div id="panelsStayOpen-collapse<?php echo e($chapterItem->id); ?>"
                                                                            class="accordion-collapse collapse"
                                                                            data-bs-parent="#accordionExample">
                                                                            <div class="accordion-body">
                                                                                <?php $__empty_3 = true; $__currentLoopData = $chapterItem->quiz->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_3 = false; ?>
                                                                                    <div class="card course-section-item mb-3"
                                                                                        data-chapter-item-id=""
                                                                                        data-chapterid="">
                                                                                        <div
                                                                                            class="d-flex flex-wrap justify-content-between align-items-center">
                                                                                            <div
                                                                                                class="edit_course_icons d-flex flex-wrap align-items-center">
                                                                                                <span
                                                                                                    class="icon-container"><i
                                                                                                        class="far fa-question-circle"></i></span>
                                                                                                <p
                                                                                                    class="mb-0 ms-2 bold-text">
                                                                                                    <?php echo e($question->title); ?>

                                                                                                </p>
                                                                                            </div>
                                                                                            <div class="item-action">
                                                                                                <a href="javascript:;"
                                                                                                    class="ms-2 text-dark edit-question-btn"
                                                                                                    data-question-id="<?php echo e($question->id); ?>"><i
                                                                                                        class="fas fa-edit"></i></a>
                                                                                                <a href="<?php echo e(route('admin.course-chapter.quiz-question.destroy', $question->id)); ?>"
                                                                                                    class="ms-2 text-danger delete-item"><i
                                                                                                        class="fas fa-trash-alt"></i></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_3): ?>
                                                                                    <p class="text-center">
                                                                                        <?php echo e(__('No questions found.')); ?></p>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                            <p class="text-center"><?php echo e(__('No lessons found.')); ?></p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <p class="text-center p-5"><?php echo e(__('No chapters found.')); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('global/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global/js/jquery.ui.touch-punch.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script src="<?php echo e(asset('backend/js/sweetalert.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course\course-content.blade.php ENDPATH**/ ?>