<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Edit Admin')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.admin.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Edit Admin')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.admin.index')); ?>"><?php echo e(__('Manage Admin')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Admin')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Admin')); ?></h4>
                                <div>
                                    <?php if(auth()->guard('admin')->user()->can('admin.view')): ?>
                                        <a href="<?php echo e(route('admin.admin.index')); ?>" class="btn btn-primary"><i
                                                class="fa fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8 offset-md-2">
                                        <form action="<?php echo e(route('admin.admin.update', $admin->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="row">
                                                <div class="form-group col-12">
                                                    <label><?php echo e(__('Name')); ?> <span class="text-danger">*</span></label>
                                                    <input type="text" id="name" class="form-control" name="name"
                                                        value="<?php echo e($admin->name); ?>">
                                                </div>
                                                <div class="form-group col-12">
                                                    <label><?php echo e(__('Email')); ?> <span class="text-danger">*</span></label>
                                                    <input type="email" id="slug" class="form-control" name="email"
                                                        value="<?php echo e($admin->email); ?>">
                                                </div>
                                                <div class="form-group col-12">
                                                    <label
                                                        title="Leave it blank if you don't want to change password"><?php echo e(__('Password')); ?>

                                                        <span class="text-success">*</span></label>
                                                    <input type="password" id="password" class="form-control"
                                                        name="password">
                                                </div>

                                                <div class="form-group col-12">
                                                    <label><?php echo e(__('Status')); ?> <span class="text-danger">*</span></label>
                                                    <select name="status" class="form-control">
                                                        <option value="active" <?php if($admin->status == 'active'): echo 'selected'; endif; ?>>
                                                            <?php echo e(__('Active')); ?></option>
                                                        <option value="inactive" <?php if($admin->status == 'inactive'): echo 'selected'; endif; ?>>
                                                            <?php echo e(__('Inactive')); ?></option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-12">
                                                    <label for="role"><?php echo e(__('Assign Role')); ?> <span
                                                            class="text-danger">*</span></label>
                                                    <select name="role[]" id="role"
                                                        class="form-control select2 <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        multiple>
                                                        <option value="" disabled><?php echo e(__('Select Role')); ?></option>
                                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($role->name); ?>"
                                                                <?php if($admin->hasRole($role->name)): echo 'selected'; endif; ?>><?php echo e($role->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="text-center col-md-8 offset-md-2">
                                                    <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\admin-list\edit_admin.blade.php ENDPATH**/ ?>