<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Courses')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class=""><?php echo e(__('Courses')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Courses List')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.course.index')); ?>" method="GET"
                                    onchange="$(this).trigger('submit')" class="form_padding">
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <input type="text" name="keyword" value="<?php echo e(request()->get('keyword')); ?>"
                                                class="form-control" placeholder="<?php echo e(__('Search')); ?>">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <input type="text" autocomplete="off" name="date" value="<?php echo e(request()->get('date')); ?>"
                                                class="form-control datepicker" placeholder="<?php echo e(__('Date')); ?>">
                                        </div>
                                        

                                        <div class="col-md-3 form-group">
                                            <select name="approve_status" id="" class="form-control">
                                                <option value=""><?php echo e(__('Approval Status')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'pending' ? 'selected' : ''); ?>

                                                    value="pending"><?php echo e(__('Pending')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'approved' ? 'selected' : ''); ?>

                                                    value="approved"><?php echo e(__('Approved')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'rejected' ? 'selected' : ''); ?>

                                                    value="rejected"><?php echo e(__('Rejected')); ?></option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="status" id="status" class="form-control">
                                                <option value=""><?php echo e(__('Status')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'active' ? 'selected' : ''); ?>

                                                    value="active"><?php echo e(__('Published')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'inactive' ? 'selected' : ''); ?>

                                                    value="inactive"><?php echo e(__('Unpublished')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'draft' ? 'selected' : ''); ?>

                                                    value="draft"><?php echo e(__('Drafted')); ?></option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="order_by" id="order_by" class="form-control">
                                                <option value=""><?php echo e(__('Order By')); ?></option>
                                                <option value="1" <?php echo e(request('order_by') == '1' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('ASC')); ?>

                                                </option>
                                                <option value="0" <?php echo e(request('order_by') == '0' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('DESC')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <select name="par_page" id="par-page" class="form-control">
                                                <option value=""><?php echo e(__('Per Page')); ?></option>
                                                <option value="10" <?php echo e('10' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('10')); ?>

                                                </option>
                                                <option value="50" <?php echo e('50' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('50')); ?>

                                                </option>
                                                <option value="100"
                                                    <?php echo e('100' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('100')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Courses List')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.verification.create')); ?>" class="btn btn-primary"> <i
                                            class="fa fa-plus"></i><?php echo e(__('Add New')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
    <div class="table-responsive max-h-400">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th><?php echo e(__('SN')); ?></th>
                    <th><?php echo e(__('Student Name')); ?></th>
                    <th><?php echo e(__('Father Name')); ?></th>
                    <th><?php echo e(__('CNIC')); ?></th>
                    <th><?php echo e(__('DOB')); ?></th>
                    <th><?php echo e(__('Grade')); ?></th>
                    <th><?php echo e(__('Percentage')); ?></th>
                    <th><?php echo e(__('Session')); ?></th>
                    <th><?php echo e(__('College')); ?></th>
                    <th><?php echo e(__('Diploma')); ?></th>
                    <th><?php echo e(__('Tenure')); ?></th>
                    <th><?php echo e(__('Reg No.')); ?></th>
                    <th><?php echo e(__('Status')); ?></th>
                    <th><?php echo e(__('Created At')); ?></th>
                    <th class="text-center"><?php echo e(__('Actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $verifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $verification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($verification->student_name); ?></td>
                        <td><?php echo e($verification->father_name); ?></td>
                        <td><?php echo e($verification->cnic_number); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($verification->date_of_birth)->format('d-m-Y')); ?></td>
                        <td><?php echo e($verification->grade); ?></td>
                        <td><?php echo e($verification->percentage); ?>%</td>
                        <td><?php echo e($verification->session); ?></td>
                        <td><?php echo e($verification->college); ?></td>
                        <td><?php echo e($verification->diploma_title); ?></td>
                        <td><?php echo e($verification->diploma_tenure); ?></td>
                        <td><?php echo e($verification->registration_number); ?></td>
                        <td>
                            <?php if($verification->status === 'active'): ?>
                                <span class="badge badge-success"><?php echo e(__('Active')); ?></span>
                            <?php elseif($verification->status === 'used'): ?>
                                <span class="badge badge-warning"><?php echo e(__('Used')); ?></span>
                            <?php else: ?>
                                <span class="badge badge-danger"><?php echo e(__('Expired')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small><?php echo e(formatDate($verification->created_at)); ?></small><br>
                            <small><?php echo e(formatDate($verification->created_at, 'H:i')); ?></small>
                        </td>
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenu2"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-ellipsis-v"></i>
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenu2">
                                    <a href="<?php echo e(route('admin.verifications.edit-view', $verification->id)); ?>"
                                        class="dropdown-item"><?php echo e(__('Edit')); ?></a>
                                    <a href="<?php echo e(route('admin.verifications.destroy', $verification->id)); ?>"
                                        class="dropdown-item text-danger delete-item"><?php echo e(__('Delete')); ?></a>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Verifications'),'route' => 'admin.verifications.create','create' => 'no','message' => __('No verifications found!'),'colspan' => '15'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="float-right">
        <?php echo e($verifications->links()); ?>

    </div>
</div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('global/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/sweetalert.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Verification\resources\views\verification\index.blade.php ENDPATH**/ ?>