<section class="instructor__area-three instructor__bg" data-background="<?php echo e(asset('frontend/img/bg/instructor_bg.jpg')); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8">
                <div class="section__title text-center mb-40">
                    <span class="sub-title"><?php echo e(__('Skilled Introduce')); ?></span>
                    <h2 class="title"><?php echo e(__('Top Class & Professional Instructors in One Place')); ?></h2>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="swiper-container instructor-active">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $selectedInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="instructor__item-three">
                                    <div class="instructor__thumb-three">
                                        <img src="<?php echo e(asset($instructor->image)); ?>" alt="img">
                                        <div class="shape-one">
                                            <img src="<?php echo e(asset('frontend/img/instructor/h2_instructor_img_shape01.svg')); ?>"
                                                alt="img" class="injectable">
                                        </div>
                                    </div>
                                    <div class="instructor__content-three">
                                        <?php
                                            $rating = round($instructor->courses->avg('avg_rating'));
                                        ?>
                                        <div class="ratting-wrap">
                                            <div class="ratting">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <?php if($i <= $rating): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php else: ?>
                                                        <i class="far fa-star"></i>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                            </div>
                                            <span>(<?php echo e(number_format($instructor->courses->avg('avg_rating'), 1)); ?>

                                                <?php echo e(__('Ratings')); ?>)</span>
                                        </div>
                                        <h2 class="title"><?php echo e($instructor->name); ?></h2>
                                        <span class="designation"><?php echo e($instructor->job_title); ?></span>
                                        <p><?php echo e($instructor->short_bio); ?></p>
                                        <div class="instructor__social">
                                            <ul class="list-wrap">
                                                <?php if($instructor->facebook): ?>
                                                    <li><a href="<?php echo e($instructor->facebook); ?>" aria-label="Facebook"><i
                                                                class="fab fa-facebook-f"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($instructor->twitter): ?>
                                                    <li><a href="<?php echo e($instructor->twitter); ?>" aria-label="Twitter"><i
                                                                class="fab fa-twitter"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($instructor->linkedin): ?>
                                                    <li><a href="<?php echo e($instructor->linkedin); ?>" aria-label="Linkedin"><i
                                                                class="fab fa-linkedin"></i></a></li>
                                                <?php endif; ?>
                                                <?php if($instructor->github): ?>
                                                    <li><a href="<?php echo e($instructor->github); ?>" aria-label="Github"><i
                                                                class="fab fa-github"></i></a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                        <div class="tg-button-wrap">
                                            <a href="<?php echo e(route('instructor-details', $instructor->id)); ?>"
                                                class="btn arrow-btn"><?php echo e(__('Join My Class')); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/right_arrow.svg')); ?>"
                                                    alt="img" class="injectable"></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-xl-9">
                <div class="instructor-slider-dot">
                    <div class="swiper instructor-nav">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $selectedInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <button><img src="<?php echo e(asset($instructor->image)); ?>" alt="img"></button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                    <div class="instructor__nav-two">
                        <div class="instructor-button-prev"><i class="flaticon-arrow-right"></i></div>
                        <div class="instructor-button-next"><i class="flaticon-arrow-right"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="instructor__shape">
        <img src="<?php echo e(asset('frontend/img/instructor/h2_instructor_shape.png')); ?>" alt="img"
            class="alltuchtopdown">
    </div>
</section>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\home\online\sections\instructor-area.blade.php ENDPATH**/ ?>