<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Order Details')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Invoice')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Invoice')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="invoice">
                    <div class="invoice-print">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-6">
                                        <h3><?php echo e(__('Invoice')); ?></h3>
                                        <address>
                                            <strong><?php echo e(__('Billed To')); ?>:</strong><br>
                                            <?php echo e($order->user->name); ?><br>
                                            <?php echo e(__('Phone:')); ?> <?php echo e($order->user->phone); ?><br>
                                            <?php echo e(__('Email')); ?> <?php echo e($order->user->email); ?><br>
                                            <?php echo e(__('Address')); ?> <?php echo e($order->user->address); ?><br>
                                        </address>
                                        <address>
                                            <strong><?php echo e(__('Payment Method')); ?>:</strong><br>
                                            <?php echo e($order->payment_method); ?><br>
                                        </address>
                                        <address>
                                            <strong><?php echo e(__('Payment Status')); ?>:</strong><br>
                                            <?php echo e($order->payment_status); ?><br><br>
                                        </address>
                                    </div>

                                    <div class="col-6 text-right">
                                        <h6><?php echo e(__('Order ')); ?> #<span
                                                class="text-primary"><?php echo e($order->invoice_id); ?></span></h6>
                                        <address>
                                            <strong><?php echo e(__('Order Date')); ?>:</strong><br>
                                            <?php echo e(formatDate($order->created_at)); ?><br><br>
                                        </address>
                                        <?php if($order->isBundleOrder()): ?>
                                            <address>
                                                <strong><?php echo e(__('Bundle Name')); ?>:</strong><br>
                                                <?php echo e($order?->order_details?->title); ?><br>
                                            </address>
                                        <?php endif; ?>
                                        <?php if($order->isGiftOrder()): ?>
                                            <address>
                                                <strong><?php echo e(__('Gift')); ?>:</strong><br>
                                                <?php echo e(__('Recipient Name')); ?>:
                                                <?php echo e($order?->order_details?->recipient_name); ?><br>
                                                <?php echo e(__('Recipient Email')); ?>:
                                                <?php echo e($order?->order_details?->recipient_email); ?><br>
                                                <?php if(empty($order?->order_details?->verification_token)): ?>
                                                    <div class="badge badge-success my-2"><?php echo e(__('Claimed')); ?></div>
                                                <?php else: ?>
                                                    <div class="badge badge-warning my-2"><?php echo e(__('Pending')); ?></div>
                                                    <br>
                                                    <a href="<?php echo e(route('admin.resend.gift-claim-mail',$order?->invoice_id)); ?>" class="btn btn-sm btn-success"><?php echo e(__('Re Send Claim Email')); ?></a>
                                                <?php endif; ?>
                                            </address>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="section-title"><?php echo e(__('Order Summary')); ?></div>
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover table-md">
                                        <tr>
                                            <th data-width="40">#</th>
                                            <th><?php echo e(__('Item')); ?></th>
                                            <th><?php echo e(__('by')); ?></th>
                                            <th class="text-center"><?php echo e(__('Price')); ?></th>
                                        </tr>
                                        <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($item->course->title); ?></td>
                                                <td>
                                                    <?php echo e($item->course->instructor->name); ?>

                                                    <br>
                                                    <?php echo e($item->course->instructor->email); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php if($order->isBundleOrder()): ?>
                                                        --
                                                    <?php else: ?>
                                                        <?php echo e(number_format($item->price * $order->conversion_rate, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-lg-4">
                                        <?php if(\Modules\BasicPayment\app\Services\PaymentMethodService::OFFLINE_PAYMENT == $order->payment_method): ?>
                                            <div class="section-title"><?php echo e(__('Payment Receipt File')); ?></div>
                                            <a class="btn btn-sm btn-success text-white cursor-pointer"
                                                href="<?php echo e(route('admin.download.payment-receipt', $order->id)); ?>"><i
                                                    class="fas fa-download"></i> <?php echo e(__('Download Receipt')); ?></a>
                                        <?php endif; ?>

                                        <form action="<?php echo e(route('admin.order.update', $order->id)); ?>" method="POST"
                                            class="d-print-none">
                                            <?php echo csrf_field(); ?>
                                            <div class="section-title"><?php echo e(__('Payment Status')); ?></div>
                                            <select name="payment_status" class="form-control" id=""
                                                <?php echo e($order->payment_status == 'paid' ? 'disabled' : ''); ?>>
                                                <option value="pending" <?php if(old('payment_status', $order->payment_status) == 'pending'): echo 'selected'; endif; ?>><?php echo e(__('Pending')); ?>

                                                </option>
                                                <option value="paid" <?php if(old('payment_status', $order->payment_status) == 'paid'): echo 'selected'; endif; ?>><?php echo e(__('Paid')); ?>

                                                </option>
                                                <option value="cancelled" <?php if(old('payment_status', $order->payment_status) == 'cancelled'): echo 'selected'; endif; ?>>
                                                    <?php echo e(__('Cancelled')); ?></option>
                                            </select>

                                            <div class="section-title"><?php echo e(__('Order Status')); ?></div>
                                            <select name="order_status" class="form-control" id="">
                                                <option value="pending" <?php if(old('order_status', $order->status) == 'pending'): echo 'selected'; endif; ?>><?php echo e(__('Pending')); ?>

                                                </option>
                                                <option value="processing" <?php if(old('order_status', $order->status) == 'processing'): echo 'selected'; endif; ?>>
                                                    <?php echo e(__('Processing')); ?></option>
                                                <option value="completed" <?php if(old('order_status', $order->status) == 'completed'): echo 'selected'; endif; ?>>
                                                    <?php echo e(__('Completed')); ?></option>
                                                <option value="declined" <?php if(old('order_status', $order->status) == 'declined'): echo 'selected'; endif; ?>><?php echo e(__('Declined')); ?>

                                                </option>
                                            </select>
                                            <button type="submit"
                                                class="btn btn-primary mt-4"><?php echo e(__('Update')); ?></button>
                                        </form>
                                    </div>
                                    <div class="col-lg-8 text-right">
                                        <?php if($order->isBundleOrder()): ?>
                                            <?php
                                                $subTotal = $order->payable_amount;
                                                $subTotalWithCharge = $subTotal * $order->conversion_rate;
                                                $gatewayCharge = 0;
                                                if ($order->gateway_charge > 0) {
                                                    $gatewayCharge =
                                                        ($order->gateway_charge / $subTotalWithCharge) * 100;
                                                }
                                                $total = number_format($subTotalWithCharge + $order->gateway_charge, 2);
                                            ?>
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Subtotal')); ?></div>
                                                <div class="invoice-detail-value">
                                                    <?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>

                                            </div>
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Gateway Charge')); ?>

                                                    (<?php echo e(number_format($gatewayCharge, 2)); ?>%)</div>
                                                <div class="invoice-detail-value">
                                                    <?php echo e(number_format($order->gateway_charge, 2)); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>
                                            </div>
                                            <hr class="mt-2 mb-2">
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Total')); ?></div>
                                                <div class="invoice-detail-value invoice-detail-value-lg">
                                                    <?php echo e($total); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <?php
                                                $subTotal = 0;
                                                $discount = 0;
                                                $gatewayCharge = 0;
                                                foreach ($order->orderItems as $item) {
                                                    $subTotal += $item->price;
                                                }
                                                $subTotalWithConversion = $subTotal * $order->conversion_rate;

                                                if ($order->coupon_discount_amount > 0) {
                                                    $discount = $order->coupon_discount_amount;
                                                }

                                                if ($order->gateway_charge > 0) {
                                                    $gatewayCharge =
                                                        ($order->gateway_charge /
                                                            ($subTotalWithConversion - $discount)) *
                                                        100;
                                                }

                                                $total = number_format(
                                                    $subTotalWithConversion - $discount + $order->gateway_charge,
                                                    2,
                                                );
                                            ?>
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Subtotal')); ?></div>
                                                <div class="invoice-detail-value">
                                                    <?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>

                                            </div>
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Gateway Charge')); ?>

                                                    (<?php echo e(number_format($gatewayCharge, 2)); ?>%)</div>
                                                <div class="invoice-detail-value">
                                                    <?php echo e(number_format($order->gateway_charge, 2)); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>
                                            </div>
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Discount')); ?></div>
                                                <div class="invoice-detail-value">
                                                    <?php echo e(number_format($discount, 2)); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>
                                            </div>
                                            <hr class="mt-2 mb-2">
                                            <div class="invoice-detail-item">
                                                <div class="invoice-detail-name"><?php echo e(__('Total')); ?></div>
                                                <div class="invoice-detail-value invoice-detail-value-lg">
                                                    <?php echo e($total); ?>

                                                    <?php echo e($order->payable_currency); ?>

                                                </div>
                                            </div>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="text-md-right">

                        <a target="_blank" href="<?php echo e(route('admin.print-invoice', $order->id)); ?>"
                            class="btn btn-warning btn-icon icon-left print-btn"><i class="fas fa-print"></i>
                            <?php echo e(__('Print')); ?></a>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div class="modal fade" tabindex="-1" role="dialog" id="delete">
        <div class="modal-dialog" role="document">
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Delete Order')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-danger"><?php echo e(__('Are You Sure to Delete this order ?')); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo e(__('Yes, Delete')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Order\resources\views\show.blade.php ENDPATH**/ ?>