<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Marketing Settings')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Marketing Settings')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Marketing Settings')); ?></div>
                </div>
            </div>
            <div class="section-body">

                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <ul class="nav nav-pills flex-column" id="marketingTab" role="tablist">
                                    <?php echo $__env->make('globalsetting::marketings.tabs.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-body">
                                <div class="tab-content" id="myTabContent2">
                                    <?php echo $__env->make('globalsetting::marketings.sections.data-layer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            "use strict";
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('#marketingTab a[href="#' + activeTab + '"]').tab('show');
            } else {
                $('#marketingTab a:first').tab('show');
            }

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                var newTab = $(e.target).attr('href').substring(1);
                localStorage.setItem('activeTab', newTab);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\marketings\index.blade.php ENDPATH**/ ?>