<?php
    $pendingOrderCount = \Modules\Order\app\Models\Order::where('payment_status', 'pending')->count();
?>
<?php use \Nwidart\Modules\Facades\Module; ?>
<li
    class="nav-item dropdown <?php echo e(isRoute(['admin.orders', 'admin.orders.*', 'admin.order', 'admin.pending-payment', 'admin.rejected-payment', 'admin.pending-orders'], 'active')); ?>">
    <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i class="fas fa-shopping-bag"></i>
        <span class="<?php echo e($pendingOrderCount > 0 ? 'beep parent' : ''); ?>"><?php echo e(__('Manage Order')); ?> </span>

    </a>
    <ul class="dropdown-menu">
        <li class="<?php echo e(isRoute('admin.orders', 'active')); ?> <?php echo e(isRoute('admin.order', 'active')); ?>"><a class="nav-link"
                href="<?php echo e(route('admin.orders')); ?>"><?php echo e(__('Order History')); ?></a></li>
        <?php if(Module::has('GiftCourse') && Module::isEnabled('GiftCourse')): ?>
            <?php
                $pendingGiftOrderCount = \Modules\Order\app\Models\Order::giftOrder()
                    ->where('payment_status', 'paid')
                    ->whereNotNull('order_details->verification_token')
                    ->count();
            ?>
            <li class="<?php echo e(isRoute('admin.orders.gift', 'active')); ?>"><a class="nav-link"
                    href="<?php echo e(route('admin.orders.gift')); ?>"><?php echo e(__('Gift Orders')); ?>

                    <?php if($pendingGiftOrderCount > 0): ?>
                        <small class="badge badge-danger ml-2"><?php echo e($pendingGiftOrderCount); ?></small>
                    <?php endif; ?>
                </a>
            </li>
        <?php endif; ?>

        <li class="<?php echo e(isRoute('admin.pending-orders', 'active')); ?>"><a class="nav-link"
                href="<?php echo e(route('admin.pending-orders')); ?>"><?php echo e(__('Pending Payment')); ?>

                <?php if($pendingOrderCount > 0): ?>
                    <small class="badge badge-danger ml-2"><?php echo e($pendingOrderCount); ?></small>
                <?php endif; ?>
            </a>
        </li>

    </ul>
</li>
<?php /**PATH D:\wamp64\www\brightfuture\Modules/Order\resources/views/sidebar.blade.php ENDPATH**/ ?>