<section class="blog__post-area-four section-pt-140 section-pb-110">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6">
                <div class="section__title text-center mb-40">
                    <span class="sub-title"><?php echo e(__('News & Blogs')); ?></span>
                    <h2 class="title"><?php echo e(__('Our Latest News Feed')); ?></h2>
                    <p><?php echo e(__('Dont Miss Stay Updated with the Latest Articles and Insights')); ?></p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <?php
                    $firstBlog = $featuredBlogs->first();
                ?>
                <div class="blog__post-item-two yoga_featured_blog">
                    <div class="blog__post-thumb-two">
                        <a href="<?php echo e(route('blog.show', $firstBlog?->slug)); ?>">
                            <img src="<?php echo e(asset($firstBlog?->image)); ?>" alt="img">
                        </a>
                    </div>
                    <div class="blog__post-content-two">
                        <a href="<?php echo e(route('blogs', ['category' => $firstBlog?->category?->slug])); ?>"
                            class="post-tag-two">
                            <?php echo e($firstBlog?->category?->title); ?>

                        </a>
                        <div class="blog__post-meta blog__post-meta-two">
                            <ul class="list-wrap">
                                <li><i class="flaticon-calendar"></i><?php echo e(formatDate($firstBlog?->created_at)); ?></li>
                                <li><i class="flaticon-user-1"></i><?php echo e(__('by')); ?>

                                    <a href="<?php echo e(route('blog.show', $firstBlog?->slug)); ?>">
                                        <?php echo e(truncate($firstBlog?->author?->name, 14)); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                        <h2 class="title">
                            <a href="<?php echo e(route('blog.show', $firstBlog?->slug)); ?>">
                                <?php echo e($firstBlog?->title); ?>

                            </a>
                        </h2>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <?php $__currentLoopData = $featuredBlogs->slice(1, 2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="blog__post-item-three shine__animate-item">
                        <div class="blog__post-thumb-three">
                            <a href="<?php echo e(route('blog.show', $blog?->slug)); ?>" class="shine__animate-link"><img
                                    src="<?php echo e(asset($blog?->image)); ?>" alt="img"></a>
                        </div>
                        <div class="blog__post-content-three">
                            <a href="<?php echo e(route('blogs', ['category' => $blog?->category?->slug])); ?>"
                                class="post-tag-two"><?php echo e($blog?->category?->title); ?></a>
                            <div class="blog__post-meta">
                                <ul class="list-wrap">
                                    <li><i class="flaticon-calendar"></i><?php echo e(formatDate($blog->created_at)); ?></li>
                                    <li><i class="flaticon-user-1"></i><?php echo e(__('by')); ?> <a
                                            href="<?php echo e(route('blog.show', $blog?->slug)); ?>"><?php echo e(truncate($blog?->author?->name, 14)); ?></a>
                                    </li>
                                </ul>
                            </div>
                            <h2 class="title"><a
                                    href="<?php echo e(route('blog.show', $blog?->slug)); ?>"><?php echo e($blog?->category?->title); ?></a>
                            </h2>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <div class="blog__shape-wrap">
        <img src="<?php echo e(asset('frontend/img/blog/h4_blog_shape.svg')); ?>" alt="shape" class="rotateme">
        <img src="<?php echo e(asset('frontend/img/blog/h4_blog_shape.svg')); ?>" alt="shape" class="rotateme">
    </div>
</section>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\home\yoga\sections\blog-area.blade.php ENDPATH**/ ?>