<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Manage Language')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Manage Language')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Manage Language')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Manage Language')); ?></h4>
                                <div>
                                    <?php if(auth()->guard('admin')->user()->can('language.create')): ?>
                                        <a href="<?php echo e(route('admin.languages.create')); ?>" class="btn btn-primary"><i
                                                class="fa fa-plus"></i><?php echo e(__('Add New')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive max-h-400">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th><?php echo e(__('Name')); ?></th>
                                                <th><?php echo e(__('Code')); ?></th>
                                                <th><?php echo e(__('Direction')); ?></th>
                                                <th><?php echo e(__('Default')); ?></th>
                                                <th><?php echo e(__('Translations')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th class="text-center"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td>
                                                        <?php echo e($loop->index + 1); ?></td>
                                                    <td>
                                                        <?php echo e($language->name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($language->code); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($language->direction == 'ltr' ? __('Left to right') : __('Right to left')); ?>

                                                    </td>
                                                    
                                                    <td>
                                                        <a href="javascript:;"
                                                            onclick="changeStatus(<?php echo e($language->id); ?>, 'is_default')">
                                                            <input class="self-default-<?php echo e($language->id); ?> default-status"
                                                                id="status_toggle" type="checkbox"
                                                                data-id="<?php echo e($language->id); ?>"
                                                                data-checked="<?php echo e($language->is_default == 1 ? 'checked' : ''); ?>"
                                                                <?php if($language->is_default == 1): ?> checked <?php endif; ?>
                                                                data-toggle="toggle" data-on="<?php echo e(__('Active')); ?>"
                                                                data-off="<?php echo e(__('Inactive')); ?>" data-onstyle="success"
                                                                data-offstyle="danger">
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <div class="dropdown d-inline">
                                                            <a class="btn btn-primary"
                                                                href="<?php echo e(route('admin.languages.edit-static-languages', $language->code)); ?>"
                                                                title="<?php echo e(__('Edit Language')); ?>">
                                                                <i class="fas fa-language"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php if($language->is_default == 0): ?>
                                                            <a href="javascript:;" class="status-<?php echo e($language->id); ?>"
                                                                onclick="changeStatus(<?php echo e($language->id); ?>, 'status')">
                                                                <input id="status_toggle" type="checkbox"
                                                                    <?php echo e($language->status ? 'checked' : ''); ?>

                                                                    data-status-id="<?php echo e($language->id); ?>"
                                                                    data-toggle="toggle" data-on="<?php echo e(__('Active')); ?>"
                                                                    data-off="<?php echo e(__('Inactive')); ?>" data-onstyle="success"
                                                                    data-offstyle="danger">
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="javascript:;" class="status-<?php echo e($language->id); ?>">
                                                                <input id="status_toggle" type="checkbox"
                                                                    <?php echo e($language->status ? 'checked' : ''); ?>

                                                                    data-status-id="<?php echo e($language->id); ?>"
                                                                    data-toggle="toggle" data-on="<?php echo e(__('Active')); ?>"
                                                                    data-off="<?php echo e(__('Inactive')); ?>" data-onstyle="success"
                                                                    data-offstyle="danger" disabled>
                                                            </a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php if($language->id != 1): ?>
                                                        <div>
                                                            <?php if(auth()->guard('admin')->user()->can('language.edit')): ?>
                                                                <a href="<?php echo e(route('admin.languages.edit', $language->id)); ?>"
                                                                    class="m-1 text-white btn btn-sm btn-warning"
                                                                    title="Edit">
                                                                    <i class="fa fa-pen"></i>
                                                                </a>
                                                            <?php endif; ?>
                                                            <a href="javascript:;" data-toggle="modal"
                                                                data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                                onclick="deleteData(<?php echo e($language->id); ?>)"><i
                                                                    class="fa fa-trash" aria-hidden="true"></i></a>
                                                        </div>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Language'),'route' => 'admin.languages.create','create' => 'yes','message' => __('No data found!'),'colspan' => '8'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="float-right">
                                    <?php echo e($languages->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        function deleteData(id) {
            $("#deleteForm").attr("action", '<?php echo e(url('/admin/languages/')); ?>' + "/" + id)
        }

        function changeStatus(id, type) {
            var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>"
            if (isDemo == 0) {
                toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                return;
            }
            $.ajax({
                type: "put",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    column: type
                },
                url: "<?php echo e(url('/admin/languages/update-status')); ?>" + "/" + id,
                success: function(response) {
                    if (response.status) {
                        toastr.success(response.message);

                        if (type == 'is_default') {
                            $('input[data-id="' + id + '"]').bootstrapToggle('on');
                            $('input[data-status-id="' + id + '"]').bootstrapToggle('on');
                            $('input[data-status-id="' + id + '"]').prop('disabled', true);
                            // remove onclick event
                            $('.status-' + id).removeAttr('onclick');
                            // turn off other button
                            $('.default-status').each(function() {
                                if ($(this).data('id') != id) {
                                    $(this).prop('checked', false);

                                    $(this).bootstrapToggle('off');
                                }
                            });

                            // remove disable attribute 
                            $('.status-' + id).removeAttr('disabled');
                        }
                        setTimeout(function() {
                            window.location.reload();
                        }, 2000);
                    } else {
                        toastr.warning(response.message);
                        if (type == 'is_default') {
                            $('input[data-id="' + id + '"]').bootstrapToggle('on');
                            $('input[data-status-id="' + id + '"]').bootstrapToggle('on');
                            // turn off other button
                            $('.default-status').each(function() {
                                if ($(this).data('id') != id) {
                                    $(this).prop('checked', false);

                                    $(this).bootstrapToggle('off');
                                }
                            });
                        }
                        console.log('console from else');
                    }
                },
                error: function(err) {
                    console.log(err);
                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .dd-custom-css {
            position: absolute;
            will-change: transform;
            top: 0px;
            left: 0px;
            transform: translate3d(0px, -131px, 0px);
        }

        .max-h-400 {
            min-height: 400px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Language\resources\views\index.blade.php ENDPATH**/ ?>