<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Post Comments')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Post Comments')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.blog-comment.index')); ?>"><?php echo e(__('Post Comments')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('All Comments')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Post Comments')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.blog-comment.index')); ?>" class="btn btn-primary"><i class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="card-body">
                                    <ul class="list-unstyled list-unstyled-border list-unstyled-noborder">
                                        <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="media">
                                                <img alt="image" class="mr-3 rounded-circle" width="70" src="<?php echo e(asset($comment->user->image)); ?>">
                                                <div class="media-body">
                                                    <div class="media-right">
                                                        <?php if($comment->status == 1): ?>
                                                            <div class="text-primary"><?php echo e(__('Approved')); ?></div>
                                                        <?php else: ?>
                                                            <div class="text-warning"><?php echo e(__('Pending')); ?></div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="mb-1 media-title"><?php echo e($comment->name); ?></div>
                                                    <div class="text-time"><?php echo e($comment?->created_at?->diffForHumans()); ?>

                                                    </div>
                                                    <div class="media-description text-muted">
                                                        <?php echo clean($comment->comment); ?>

                                                    </div>
                                                    <div class="media-links">
                                                        <a target="_blank" href="<?php echo e(route('blog.show', $comment->post->slug)); ?>"><?php echo e(__('View')); ?></a>
                                                        <div class="bullet"></div>
                                                        <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" onclick="deleteData(<?php echo e($comment->id); ?>)" class="text-danger"><?php echo e(__('Trash')); ?></a>
                                                    </div>
                                                </div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <div class="float-right">
                                    <?php echo e($comments->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id) {
            $("#deleteForm").attr("action", '<?php echo e(url("/admin/blog-comment/")); ?>' + "/" + id)
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Blog\resources\views\Comment\show.blade.php ENDPATH**/ ?>