<?php $__env->startSection('dashboard-contents'); ?>
<a href="<?php echo e(route('student.reviews.index')); ?>" class="btn mb-3"><?php echo e(__('My Reviews')); ?></a>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Review Details')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td><?php echo e(__('Course')); ?></td>
                                <td><?php echo e($review->course->title); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Rating')); ?></td>
                                <td>
                                    <?php for($i = 0; $i < $review->rating; $i++): ?>
                                        <i class="fa fa-star text-warning"></i>
                                    <?php endfor; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Review')); ?></td>
                                <td><?php echo e($review->review); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Date')); ?></td>
                                <td><?php echo e(formatDate($review->created_at)); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('Status')); ?></td>
                                <td>
                                    <?php if($review->status == 1): ?>
                                        <div class="badge bg-success"><?php echo e(__('Approved')); ?></div>
                                    <?php else: ?>
                                        <div class="badge bg-warning"><?php echo e(__('Pending')); ?></div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\review\show.blade.php ENDPATH**/ ?>