<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Review Details')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Review Details')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Review Details')); ?></div>
                </div>
            </div>

            <a href="<?php echo e(route('admin.course-review.index')); ?>" class="btn btn-primary"><?php echo e(__('Review List')); ?></a>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Details')); ?></h4>
                                <div>
                                </div>
                            </div>
                            <div class="card-body">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td><?php echo e(__('Course')); ?></td>
                                            <td><?php echo e($review->course->title); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('Rating')); ?></td>
                                            <td>
                                                <?php for($i = 0; $i < $review->rating; $i++): ?>
                                                    <i class="fa fa-star text-warning"></i>
                                                <?php endfor; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('Review')); ?></td>
                                            <td><?php echo e($review->review); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('Date')); ?></td>
                                            <td><?php echo e(formatDate($review->created_at)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('Status')); ?></td>
                                            <td>
                                                <form action="<?php echo e(route('admin.course-review.update', $review->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="d-flex">
                                                     
                                                            <select name="status" id="" class="form-control w-25">
                                                                <option <?php if($review->status == 0): echo 'selected'; endif; ?> value="0"><?php echo e(__('Pending')); ?></option>
                                                                <option <?php if($review->status == 1): echo 'selected'; endif; ?> value="1"><?php echo e(__('Approved')); ?></option>
                                                            </select>
                                                       
                                                        <div><button type="submit"
                                                            class="btn btn-primary ml-2 mt-1"><?php echo e(__('Update')); ?></button></div>
                                                    </div>
                                                   
                                                </form>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course-review\show.blade.php ENDPATH**/ ?>