<div class="modal-header">
    <h6 class="modal-title fs-5" id=""><?php echo e(__('Update Quiz Question')); ?></h6>
</div>

<div class="modal-body">
    <form action="<?php echo e(route('admin.course-chapter.quiz-question.update', $question->id)); ?>" method="POST"
        class="add_lesson_form instructor__profile-form">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="col-md-10">
                <div class="form-group">
                    <label for="title"><?php echo e(__('Question Title')); ?> <code>*</code></label>
                    <input id="title" name="title" type="text" class="form-control"
                        value="<?php echo e($question->title); ?>">
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label for="title"><?php echo e(__('Grade')); ?> <code>*</code></label>
                    <input id="title" name="grade" type="text" class="form-control"
                        value="<?php echo e($question->grade); ?>">
                </div>
            </div>
        </div>

        <div>
            <button class="add-answer btn" type="button"><?php echo e(__('Add Answer')); ?></button>
        </div>

        <div class="answer-container">
            <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mt-3">
                    <div class="card-body">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="d-flex justify-content-between">
                                    <label for="answer"><?php echo e(__('Answer Title')); ?> <code>*</code></label>
                                    <button class="remove-answer" type="button"><i
                                            class="fas fa-trash-alt"></i></button>
                                </div>
                                <input class="answer form-control" name="answers[<?php echo e($answer->id); ?>]" type="text"
                                    value="<?php echo e($answer->title); ?>" required>
                            </div>
                            <div class="switcher d-flex mt-2">
                                <p class="mr-3"><?php echo e(__('Correct Answer')); ?></p>
                                <label for="toggle-<?php echo e($answer->id); ?>">
                                    <input class="correct" type="checkbox" id="toggle-<?php echo e($answer->id); ?>"
                                        value="1" name="correct[<?php echo e($answer->id); ?>]"
                                        <?php if($answer->correct == 1): echo 'checked'; endif; ?> />
                                    <span><small></small></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>


        <div class="modal-footer">
            <button type="submit" class="btn btn-primary submit-btn"><?php echo e(__('Update')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course\partials\quiz-question-edit-modal.blade.php ENDPATH**/ ?>