<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Email Configuration')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Email Configuration')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Email Configuration')); ?></div>
                </div>
            </div>
            <div class="section-body">

                <div class="row">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="card-body">
                                <ul class="nav nav-pills flex-column" id="emailTab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active show" id="setting-tab" data-toggle="tab"
                                            href="#setting_tab" role="tab" aria-controls="setting"
                                            aria-selected="true"><?php echo e(__('Setting')); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="email-template-tab" data-toggle="tab"
                                            href="#email_template_tab" role="tab" aria-controls="email-template"
                                            aria-selected="false"><?php echo e(__('Email Template')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="card">
                            <div class="card-body">
                                <div class="tab-content" id="myTabContent2">
                                    <div class="tab-pane fade active show" id="setting_tab" role="tabpanel">
                                        <form action="<?php echo e(route('admin.update-email-configuration')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="name"><?php echo e(__('Sender Name')); ?></label>
                                                        <input type="text" name="mail_sender_name"
                                                            value="<?php echo e($setting->mail_sender_name); ?>" class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="email"><?php echo e(__('Sender Email')); ?></label>
                                                        <?php if(env('APP_MODE') == 'DEMO'): ?>
                                                            <input type="email" name="mail_sender_email"
                                                                value="no-reply@gmail.com" class="form-control">
                                                        <?php else: ?>
                                                            <input type="email" name="mail_sender_email"
                                                                value="<?php echo e($setting->mail_sender_email); ?>"
                                                                class="form-control">
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="email"><?php echo e(__('Recipient email')); ?></label>
                                                        <input type="email" name="contact_message_receiver_mail"
                                                            value="<?php echo e($setting->contact_message_receiver_mail); ?>"
                                                            class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="name"><?php echo e(__('Mail Host')); ?></label>
                                                        <?php if(env('APP_MODE') == 'DEMO'): ?>
                                                            <input type="text" name="mail_host" value="test.mailhost"
                                                                class="form-control">
                                                        <?php else: ?>
                                                            <input type="text" name="mail_host"
                                                                value="<?php echo e($setting->mail_host); ?>" class="form-control">
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="name"><?php echo e(__('SMTP User Name')); ?></label>
                                                        <?php if(env('APP_MODE') == 'DEMO'): ?>
                                                            <input type="text" name="mail_username"
                                                                value="no-reply@gmail.com" class="form-control">
                                                        <?php else: ?>
                                                            <input type="text" name="mail_username"
                                                                value="<?php echo e($setting->mail_username); ?>" class="form-control">
                                                        <?php endif; ?>
                                                    </div>
                                                </div>


                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="name"><?php echo e(__('SMTP Password')); ?></label>
                                                        <?php if(env('APP_MODE') == 'DEMO'): ?>
                                                            <div class="input-group-append">
                                                                <input type="password" name="mail_password"
                                                                    value="password1234" class="form-control">
                                                                <div class="input-group-text cursor-pointer toggle-password-icon">
                                                                    <i class="fas fa-eye"></i>
                                                                </div>
                                                            </div>
                                                        <?php else: ?>
                                                            <div class="input-group-append">
                                                                <input type="password" name="mail_password"
                                                                    value="<?php echo e($setting->mail_password); ?>"
                                                                    class="form-control">
                                                                <div class="input-group-text cursor-pointer toggle-password-icon">
                                                                    <i class="fas fa-eye"></i>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>

                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="mail_port"><?php echo e(__('Mail Port')); ?></label>
                                                        <input type="text" name="mail_port"
                                                            value="<?php echo e($setting->mail_port); ?>" class="form-control"
                                                            id="mail_port">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="mail_encryption"><?php echo e(__('Mail Encryption')); ?></label>
                                                        <select name="mail_encryption" id="mail_encryption"
                                                            class="form-control">
                                                            <option
                                                                <?php echo e($setting->mail_encryption == 'tls' ? 'selected' : ''); ?>

                                                                value="tls"><?php echo e(__('TLS')); ?></option>
                                                            <option
                                                                <?php echo e($setting->mail_encryption == 'ssl' ? 'selected' : ''); ?>

                                                                value="ssl"><?php echo e(__('SSL')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <button type="submit" class="btn btn-success"><?php echo e(__('Update')); ?></button>
                                            
                                            <?php if(
                                                $setting->mail_username != 'mail_username' &&
                                                    $setting->mail_password != 'mail_password' &&
                                                    $setting->mail_port != 'mail_port'): ?>
                                                <?php ($test_email = true); ?>
                                                <button class="btn btn-primary" data-toggle="modal" type="button"
                                                    data-target="#testEmail"><?php echo e(__('Test Mail Credentials')); ?></button>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                    <div class="tab-pane fade" id="email_template_tab" role="tabpanel">
                                        <div class="table-responsive table-invoice">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo e(__('SN')); ?></th>
                                                        <th><?php echo e(__('Email Template')); ?></th>
                                                        <th><?php echo e(__('Subject')); ?></th>
                                                        <th><?php echo e(__('Action')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($item->name == 'gift_course' && ! Nwidart\Modules\Facades\Module::has('GiftCourse')): ?>
                                                            <?php continue; ?>
                                                        <?php endif; ?>
                                                        <tr>
                                                            <td><?php echo e(++$index); ?></td>
                                                            <td><?php echo e(ucfirst(Str::replace('_', ' ', $item->name))); ?></td>
                                                            <td><?php echo e($item->subject); ?></td>
                                                            <td>
                                                                <a href="<?php echo e(route('admin.edit-email-template', $item->id)); ?>"
                                                                    class="btn btn-success btn-sm"><i
                                                                        class="fas fa-edit"></i></a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    
    <?php if($test_email ?? false): ?>
        <div class="modal fade" tabindex="-1" role="dialog" id="testEmail">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title pl-4"><?php echo e(__('Test Mail Credentials')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(__('Are You sure want to test your mail Credentials?')); ?></p>
                    </div>
                    <div class="modal-footer bg-whitesmoke br">
                        <form action="<?php echo e(route('admin.test-mail-credentials')); ?>" action="" method="POST">
                            <?php echo csrf_field(); ?>
                            <button type="button" class="btn btn-danger"
                                data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Yes')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            "use strict";
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('#emailTab a[href="#' + activeTab + '"]').tab('show');
            } else {
                $('#emailTab a:first').tab('show');
            }

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                var newTab = $(e.target).attr('href').substring(1);
                localStorage.setItem('activeTab', newTab);
            });

            $('.toggle-password-icon').click(function () {
                var input = $('input[name="mail_password"]');
                var $icon = $(this).find('i');
                input.attr('type', input.attr('type') === 'password' ? 'text' : 'password');
                $icon.toggleClass('fa-eye fa-eye-slash');
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\email\email_config.blade.php ENDPATH**/ ?>