<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Manage Admin')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Manage Admin')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Manage Admin')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Manage Admin')); ?></h4>
                                <div>
                                    <?php if(auth()->guard('admin')->user()->can('admin.create')): ?>
                                        <a href="<?php echo e(route('admin.admin.create')); ?>" class="btn btn-primary"><i
                                                class="fa fa-plus"></i> <?php echo e(__('Add New')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th><?php echo e(__('Name')); ?></th>
                                                <th><?php echo e(__('Email')); ?></th>
                                                <th><?php echo e(__('Roles')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <?php if(auth()->guard('admin')->user()->can('admin.delete')): ?>
                                                    <th><?php echo e(__('Action')); ?></th>
                                                <?php endif; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e(++$index); ?></td>
                                                    <td><?php echo e($admin->name); ?></td>
                                                    <td><?php echo e($admin->email); ?></td>
                                                    <td>
                                                        <?php $__currentLoopData = $admin->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge badge-primary"><?php echo e($role); ?></span>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </td>
                                                    <td>
                                                        <?php if($admin->id != 1): ?>
                                                        <?php if($admin->status == 'active'): ?>
                                                            <a href="javascript:;"
                                                                onclick="changeAdminStatus(<?php echo e($admin->id); ?>)">
                                                                <input id="status_toggle" type="checkbox" checked
                                                                    data-toggle="toggle" data-on="<?php echo e(__('Active')); ?>"
                                                                    data-off="<?php echo e(__('Inactive')); ?>" data-onstyle="success"
                                                                    data-offstyle="danger">
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="javascript:;"
                                                                onclick="changeAdminStatus(<?php echo e($admin->id); ?>)">
                                                                <input id="status_toggle" type="checkbox"
                                                                    data-toggle="toggle" data-on="<?php echo e(__('Active')); ?>"
                                                                    data-off="<?php echo e(__('Inactive')); ?>" data-onstyle="success"
                                                                    data-offstyle="danger">
                                                            </a>
                                                        <?php endif; ?>
                                                        <?php else: ?>
                                                            <span class="text-muted"><?php echo e(__('( default admin )')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <?php if(auth()->guard('admin')->user()->can('admin.delete')): ?>
                                                        <td>
                                                            <?php if($admin->id != 1): ?>
                                                            <?php if(auth()->guard('admin')->user()->can('admin.edit')): ?>
                                                                <a href="<?php echo e(route('admin.admin.edit', $admin->id)); ?>"
                                                                    class="btn btn-warning btn-sm"><i class="fa fa-edit"
                                                                        aria-hidden="true"></i></a>
                                                            <?php endif; ?>
                                                            <?php if(auth()->guard('admin')->user()->can('admin.delete')): ?>
                                                                <a href="javascript:;" data-toggle="modal"
                                                                    data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                                    onclick="deleteData(<?php echo e($admin->id); ?>)"><i
                                                                        class="fa fa-trash" aria-hidden="true"></i></a>
                                                            <?php endif; ?>
                                                            <?php else: ?>
                                                                <span class="text-muted"><?php echo e(__('( default admin )')); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="float-right">
                                        <?php echo e($admins->links()); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id) {
            $("#deleteForm").attr("action", "<?php echo e(url('admin/admin/')); ?>" + "/" + id)
        }

        function changeAdminStatus(id) {
            var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>"
            if (isDemo == 0) {
                toastr.error('This Is Demo Version. You Can Not Change Anything');
                return;
            }
            $.ajax({
                type: "put",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                url: "<?php echo e(url('/admin/admin-status/')); ?>" + "/" + id,
                success: function(response) {
                    toastr.success(response.message)
                },
                error: function(err) {
                    console.log(err);
                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\admin-list\admin.blade.php ENDPATH**/ ?>