<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Instructor Request Settings')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Instructor Request Settings')); ?></h1>
            </div>

            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>

                            <hr>
                            <?php if($code !== $languages->first()->code): ?>
                                <button class="btn btn-primary" id="translate-btn"><?php echo e(__('Translate')); ?></button>
                            <?php endif; ?>

                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.instructor-request-setting.index', ['code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.instructor-request-setting.update', ['instructor_request_setting' => 1, 'code' => $code])); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label><?php echo e(__('Do Instructor need to submit document / certificate?')); ?> <span
                                                    class="text-danger">*</span></label>
                                            <select name="need_certificate" class="form-control">
                                                <option <?php if($instructorRequestSetting?->need_certificate == 1): echo 'selected'; endif; ?> value="1"><?php echo e(__('Yes')); ?></option>
                                                <option <?php if($instructorRequestSetting?->need_certificate == 0): echo 'selected'; endif; ?> value="0"><?php echo e(__('No')); ?></option>
                                            </select>
                                        </div>
                                        <div class="form-group col-6">
                                            <label><?php echo e(__('Do Instructor need to submit Identity Scan?')); ?> <span
                                                    class="text-danger">*</span></label>
                                            <select name="need_identity_scan" class="form-control">
                                                <option <?php if($instructorRequestSetting?->need_identity_scan == 1): echo 'selected'; endif; ?> value="1"><?php echo e(__('Yes')); ?></option>
                                                <option <?php if($instructorRequestSetting?->need_identity_scan == 0): echo 'selected'; endif; ?> value="0"><?php echo e(__('No')); ?></option>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-12">
                                          <label><?php echo e(__('Instructions for Instructor')); ?> <span
                                                  class="text-danger">*</span></label>
                                          <textarea name="instructions" class="form-control summernote"><?php echo e($instructorRequestSetting?->getTranslation($code)?->instructions); ?></textarea>
                                          <small><?php echo e(__('this will be displayed on the top of the become instructor page')); ?></small>
                                      </div>
                                  
                                    </div>
                                    <br>
                                    <br>

                                    <div class="row">
                                        <div class="col-12">
                                            <button class="btn btn-primary"><?php echo e(__('Save changes')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\InstructorRequest\resources\views\instructor-request-setting\index.blade.php ENDPATH**/ ?>