<section class="courses-area-five section-py-140 courses__bg-four"
    data-background="<?php echo e(asset('frontend/img/bg/h6_courses_bg.jpg')); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9 col-xl-8 col-xxl-6">
                <div class="section__title text-center mb-50">
                    <span class="sub-title"><?php echo e(__('Top Class Courses')); ?></span>
                    <h2 class="title bold"><?php echo e(__('Get The Best Exciting Class Experience With us')); ?></h2>
                    <p class="desc"><?php echo e(__('Check out the most demanding courses right now')); ?></p>
                </div>
            </div>
            <div class="col-xxl-10 col-xl-9 col-lg-10">
                <div class="courses__nav-two mb-50">
                    <ul class="nav nav-tabs" id="courseTab" role="tablist">
                        <?php
                            $allCoursesIds = json_decode(
                                $featuredCourse?->all_category_ids ? $featuredCourse->all_category_ids : '[]',
                            );
                            $allCourses = App\Models\Course::with(
                                'favoriteBy',
                                'category.translation',
                                'instructor:id,name',
                            )
                                ->whereIn('id', $allCoursesIds)
                                ->withCount([
                                    'reviews as avg_rating' => function ($query) {
                                        $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                    },
                                ])
                                ->withCount([
                                    'lessons' => function ($query) {
                                        $query->where('status', 'active');
                                    },
                                ])
                                ->withCount('enrollments')
                                ->get();
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="all-tab" data-bs-toggle="tab"
                                data-bs-target="#all-tab-pane" type="button" role="tab"
                                aria-controls="all-tab-pane" aria-selected="true">
                                <?php echo e(__('All')); ?>

                            </button>
                        </li>
                        <?php if($featuredCourse?->category_one_status == 1): ?>
                            <li class="nav-item" role="presentation">
                                <?php
                                    $categoryOne = Modules\Course\app\Models\CourseCategory::with(['translation'])
                                        ->where('id', $featuredCourse->category_one)
                                        ->first();
                                    $categoryOneIds = json_decode($featuredCourse->category_one_ids);
                                    $categoryOneCourses = App\Models\Course::with(
                                        'favoriteBy',
                                        'category.translation',
                                        'instructor:id,name',
                                    )
                                        ->whereIn('id', $categoryOneIds)
                                        ->withCount([
                                            'reviews as avg_rating' => function ($query) {
                                                $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                            },
                                        ])
                                        ->withCount('enrollments')
                                        ->get();
                                ?>
                                <button class="nav-link" id="chinese-tab" data-bs-toggle="tab"
                                    data-bs-target="#chinese-tab-pane" type="button" role="tab"
                                    aria-controls="chinese-tab-pane" aria-selected="false">
                                    <?php echo e($categoryOne?->name); ?>

                                </button>
                            </li>
                        <?php endif; ?>
                        <?php if($featuredCourse?->category_two_status == 1): ?>
                            <li class="nav-item" role="presentation">
                                <?php
                                    $categoryTwo = Modules\Course\app\Models\CourseCategory::with(['translation'])
                                        ->where('id', $featuredCourse->category_two)
                                        ->first();
                                    $categoryTwoIds = json_decode($featuredCourse->category_two_ids);
                                    $categoryTwoCourses = App\Models\Course::with(
                                        'favoriteBy',
                                        'category.translation',
                                        'instructor:id,name',
                                    )
                                        ->whereIn('id', $categoryTwoIds)
                                        ->withCount([
                                            'reviews as avg_rating' => function ($query) {
                                                $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                            },
                                        ])
                                        ->withCount('enrollments')
                                        ->get();
                                ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="dessert-tab" data-bs-toggle="tab"
                                    data-bs-target="#dessert-tab-pane" type="button" role="tab"
                                    aria-controls="dessert-tab-pane" aria-selected="false">
                                    <?php echo e($categoryTwo?->name); ?>

                                </button>
                            </li>
                        <?php endif; ?>
                        <?php if($featuredCourse?->category_three_status == 1): ?>
                            <li class="nav-item" role="presentation">
                                <?php
                                    $categoryThree = Modules\Course\app\Models\CourseCategory::with(['translation'])
                                        ->where('id', $featuredCourse->category_three)
                                        ->first();
                                    $categoryThreeIds = json_decode($featuredCourse->category_three_ids);
                                    $categoryThreeCourses = App\Models\Course::with(
                                        'favoriteBy',
                                        'category.translation',
                                        'instructor:id,name',
                                    )
                                        ->whereIn('id', $categoryThreeIds)
                                        ->withCount([
                                            'reviews as avg_rating' => function ($query) {
                                                $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                            },
                                        ])
                                        ->withCount('enrollments')
                                        ->get();
                                ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="italian-tab" data-bs-toggle="tab"
                                    data-bs-target="#italian-tab-pane" type="button" role="tab"
                                    aria-controls="italian-tab-pane" aria-selected="false">
                                    <?php echo e($categoryThree?->name); ?>

                                </button>
                            </li>
                        <?php endif; ?>
                        <?php if($featuredCourse?->category_four_status == 1): ?>
                            <li class="nav-item" role="presentation">
                                <?php
                                    $categoryFour = Modules\Course\app\Models\CourseCategory::with(['translation'])
                                        ->where('id', $featuredCourse->category_four)
                                        ->first();
                                    $categoryFourIds = json_decode($featuredCourse->category_four_ids);
                                    $categoryFourCourses = App\Models\Course::with(
                                        'favoriteBy',
                                        'category.translation',
                                        'instructor:id,name',
                                    )
                                        ->whereIn('id', $categoryFourIds)
                                        ->withCount([
                                            'reviews as avg_rating' => function ($query) {
                                                $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                            },
                                        ])
                                        ->withCount('enrollments')
                                        ->get();
                                ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pizza-tab" data-bs-toggle="tab"
                                    data-bs-target="#pizza-tab-pane" type="button" role="tab"
                                    aria-controls="pizza-tab-pane" aria-selected="false">
                                    <?php echo e($categoryFour?->name); ?>

                                </button>
                            </li>
                        <?php endif; ?>
                        <?php if($featuredCourse?->category_five_status == 1): ?>
                            <li class="nav-item" role="presentation">
                                <?php
                                    $categoryFive = Modules\Course\app\Models\CourseCategory::with(['translation'])
                                        ->where('id', $featuredCourse->category_five)
                                        ->first();
                                    $categoryFiveIds = json_decode($featuredCourse->category_five_ids);
                                    $categoryFiveCourses = App\Models\Course::with(
                                        'favoriteBy',
                                        'category.translation',
                                        'instructor:id,name',
                                    )
                                        ->whereIn('id', $categoryFiveIds)
                                        ->withCount([
                                            'reviews as avg_rating' => function ($query) {
                                                $query->select(DB::raw('coalesce(avg(rating), 0)'));
                                            },
                                        ])
                                        ->withCount('enrollments')
                                        ->get();
                                ?>
                                <button class="nav-link" id="development-tab" data-bs-toggle="tab"
                                    data-bs-target="#development-tab-pane" type="button" role="tab"
                                    aria-controls="development-tab-pane" aria-selected="false">
                                    <?php echo e($categoryFive?->name); ?>

                                </button>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="all-tab-pane" role="tabpanel" aria-labelledby="all-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $allCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;" class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="chinese-tab-pane" role="tabpanel" aria-labelledby="chinese-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $categoryOneCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;"
                                        class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="dessert-tab-pane" role="tabpanel" aria-labelledby="dessert-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $categoryTwoCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;"
                                        class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="italian-tab-pane" role="tabpanel" aria-labelledby="italian-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $categoryThreeCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;"
                                        class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="pizza-tab-pane" role="tabpanel" aria-labelledby="pizza-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $categoryFourCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;"
                                        class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane fade" id="development-tab-pane" role="tabpanel" aria-labelledby="development-tab"
                tabindex="0">
                <div class="row justify-content-center">
                    <?php $__currentLoopData = $categoryFiveCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-3 col-lg-4 col-md-6">
                            <div class="courses__item-seven">
                                <div class="courses__item-thumb-six">
                                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="<?php echo e($course->title); ?>"></a>
                                    <a href="javascript:;"
                                        class="wsus-wishlist-btn common-white courses__wishlist-two"  aria-label="WishList"
                                        data-slug="<?php echo e($course?->slug); ?>">
                                        <i class="<?php echo e($course?->favorite_by_client ? 'fas' : 'far'); ?> fa-heart"></i>
                                    </a>
                                    <a href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"
                                        class="courses__item-tag-three"><?php echo e($course->category?->name); ?></a>
                                    <div class="courses__review">
                                        <div class="rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= floor($course->avg_rating)): ?>
                                                    <i class="fas fa-solid fa-star"></i>
                                                <?php elseif($i - 0.5 <= $course->avg_rating): ?>
                                                    <i class="fas fa-solid fa-star-half-alt"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>)</span>
                                    </div>
                                </div>
                                <div class="courses__item-content-six">
                                    <div class="courses__item-content-six-top">
                                        <h2 class="title"><a
                                                href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e($course?->instructor?->name); ?></a>
                                        </h2>
                                        <?php if($course->price == 0): ?>
                                            <h3 class="price"><?php echo e(__('Free')); ?></h3>
                                        <?php elseif($course->price > 0 && $course->discount > 0): ?>
                                            <h3 class="price"><?php echo e(currency($course->discount)); ?></h3>
                                        <?php else: ?>
                                            <h3 class="price"><?php echo e(currency($course->price)); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <span><?php echo e(__('Professional Tutor')); ?></span>
                                    <ul class="courses__item-meta-two list-wrap">
                                        <?php $__currentLoopData = $course->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($item?->language?->name); ?> <img
                                                    src="<?php echo e(asset('frontend/img/icons/graph.svg')); ?>" alt=""
                                                    class="injectable"></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <p><?php echo e(truncate($course->title, 50)); ?></p>
                                </div>
                                <div class="courses__item-bottom-three courses__item-bottom-four">
                                    <ul class="list-wrap">
                                        <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                            <?php echo e($course?->lessons_count); ?></li>
                                        <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                            <?php echo e($course?->enrollments_count); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="view-all-btn view-all-categories">
            <a href="<?php echo e(route('courses')); ?>"><span><?php echo e(__('See All Courses')); ?></span><img
                    src="<?php echo e(asset('frontend/img/icons/right_arrow.svg')); ?>" alt="" class="injectable"></a>
        </div>
    </div>
</section>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\home\language\sections\course-area.blade.php ENDPATH**/ ?>