<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Translate Language')); ?> (<?php echo e($language->name); ?>)</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.languages.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Translate Language')); ?> (<?php echo e($language->name); ?>)</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active">
                        <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active">
                        <a href="<?php echo e(route('admin.languages.index')); ?>"><?php echo e(__('Manage Language')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Translate Language')); ?> (<?php echo e($language->name); ?>)</div>
                </div>
            </div>

            <div class="section-body">

                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <h5 class="service_card"><?php echo e(__('Language Translations')); ?></h5>
                            <div>
                                <a href="<?php echo e(route('admin.languages.index')); ?>" class="btn btn-primary"><i
                                        class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                            </div>
                        </div>
                        <hr>
                        <div class="lang_list_top">
                            <ul class="lang_list">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('admin.languages.edit-static-languages', $lang->code)); ?>"><i
                                                class="fas <?php echo e($lang->code !== request('code') ? 'fa-edit' : 'fa-eye'); ?>"></i>
                                            <?php echo e($lang->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <div class="mt-2 alert alert-danger" role="alert">
                            <p><?php echo e(__('Your editing mode')); ?> : <b><?php echo e($language->name); ?></b></p>
                        </div>
                    </div>
                </div>

                <div class="mt-4 row">
                    <div class="col">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit')); ?> <?php echo e(ucwords(str_replace(['_', '-'], ' ', request('file')))); ?>

                                    <?php echo e(__('Language')); ?></h4>
                                <div>
                                    <form onchange="$(this).trigger('submit')"
                                        action="<?php echo e(route('admin.languages.edit-static-languages', ['code' => request('code'), 'file' => request('file')])); ?>"
                                        method="get">

                                        <div class="input-group">
                                            <input type="text" name="search" class="form-control search-input"
                                                value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(__('Search')); ?>">
                                            <button type="submit"
                                                class="btn btn-lg btn-primary"><?php echo e(__('Search')); ?></button>
                                        </div>
                                    </form>
                                </div>
                                <button type="button" id="translateAll" class="btn btn-primary"
                                    data-code="<?php echo e(request('code')); ?>"
                                    data-file="<?php echo e(request('file')); ?>"><?php echo e(__('Translate All To ')); ?><?php echo e($language->name); ?></button>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.languages.update-static-languages', request('code'))); ?>"
                                    method="post">
                                    <?php echo csrf_field(); ?>
                                    <table class="table table-bordered">
                                        <?php ($paginateData = []); ?>
                                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td width="50%"><?php echo e($index); ?></td>
                                                <td width="50%">
                                                    <input type="text" id="translation-<?php echo e($loop->index + 1); ?>"
                                                        class="form-control" name="values[<?php echo e($index); ?>]"
                                                        value="<?php echo e($value); ?>">
                                                </td>
                                                <td>
                                                    <span class="d-flex">
                                                        <button type="button"
                                                            onclick="AutoTrans('translation-<?php echo e($loop->index + 1); ?>', '<?php echo e($index); ?>', '<?php echo e(request('code')); ?>')"
                                                            class="ml-1 text-white btn btn-sm bg-success lang-btn">
                                                            <?php echo e(__('Translate')); ?>

                                                        </button>
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php ($paginateData[$index] = $value); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-lg btn-primary"><?php echo e(__('Update')); ?></button>
                                    </div>
                                </form>
                            </div>
                            <div class="card-footer d-flex justify-content-center">
                                <?php echo e($data->onEachSide(0)->links()); ?>

                            </div>

                        </div>
                    </div>
                </div>
            </div>


        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<style>
    .form-control.search-input{
        margin-bottom: 0!important
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/iziToast.min.js')); ?>"></script>
    <script>
        function AutoTrans(key, value, lang) {
            $('.lang-btn').prop('disabled', true);

            $.ajax({
                url: "<?php echo e(route('admin.languages.update.single')); ?>",
                type: "POST",
                data: {
                    lang: lang,
                    text: value,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                dataType: 'json',
                beforeSend: function() {
                    iziToast.show({
                        timeout: false,
                        close: false,
                        theme: 'dark',
                        icon: 'loader',
                        iconUrl: 'https://hub.izmirnic.com/Files/Images/loading.gif',
                        title: "<?php echo e(__('Translation Processing, please wait...')); ?>",
                        position: 'center',
                    });
                },
                success: function(result) {
                    $('input[id=' + key + ']').val(result);
                    $('.lang-btn').prop('disabled', false);
                    iziToast.destroy();
                    toastr.success('Success', 'Success');
                },
                error: function(file, response) {
                    console.log(response);
                    iziToast.destroy();
                    toastr.error('Error', 'Error');
                    setTimeout(() => {
                        $('.lang-btn').prop('disabled', false);
                    }, 1000);
                }
            });
        }
    </script>

    <script>
        $('#translateAll').on('click', function() {
            iziToast.question({
                timeout: 20000,
                close: false,
                overlay: true,
                displayMode: 'once',
                id: 'question',
                zindex: 999,
                title: "<?php echo e(__('This will take a while!')); ?>",
                message: "<?php echo e(__('Are you sure?')); ?>",
                position: 'center',
                buttons: [
                    ["<button><b><?php echo e(__('YES')); ?></b></button>", function(instance, toast) {
                        var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>";
                        var code = $('#translateAll').data('code');
                        var file = $('#translateAll').data('file');

                        if (isDemo == 0) {
                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');
                            toastr.error(
                                "<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>"
                            );
                            return;
                        }

                        $.ajax({
                            type: "post",
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>',
                                code: code,
                                file: file,
                                texts: "<?php echo e(json_encode($paginateData)); ?>",
                            },
                            url: "<?php echo e(route('admin.languages.translateAll')); ?>",
                            beforeSend: function() {
                                instance.hide({
                                    transitionOut: 'fadeOut'
                                }, toast, 'button');

                                iziToast.show({
                                    timeout: false,
                                    close: true,
                                    theme: 'dark',
                                    icon: 'loader',
                                    iconUrl: 'https://hub.izmirnic.com/Files/Images/loading.gif',
                                    title: "<?php echo e(__('This will take a while! wait....')); ?>",
                                    position: 'center',
                                });
                                $('.lang-btn').prop('disabled', true);
                            },
                            success: function(response) {
                                if (response.success) {
                                    $('.lang-btn').prop('disabled', false);
                                    iziToast.destroy();
                                    toastr.success(response.message);
                                    setTimeout(function() {
                                        window.location.reload();
                                    }, 2000);
                                }
                            },
                            error: function(err) {
                                $('.lang-btn').prop('disabled', false);
                                iziToast.destroy();
                                toastr.error("<?php echo e(__('Failed!')); ?>")
                                console.log(err);
                            },
                        })

                    }, true],
                    ["<button><?php echo e(__('NO')); ?></button>", function(instance, toast) {

                        instance.hide({
                            transitionOut: 'fadeOut'
                        }, toast, 'button');

                    }],
                ],
                onClosing: function(instance, toast, closedBy) {},
                onClosed: function(instance, toast, closedBy) {}
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Language\resources\views\edit-static-language.blade.php ENDPATH**/ ?>