<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Post Comments')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Post Comments')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Post Comments')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Post Comments')); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive max-h-400">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th width="5%"><?php echo e(__('SN')); ?></th>
                                                <th width="30%"><?php echo e(__('Comment')); ?></th>
                                                <th width="15%"><?php echo e(__('Post')); ?></th>
                                                <th width="10%"><?php echo e(__('Author')); ?></th>
                                                <th width="10%"><?php echo e(__('Email')); ?></th>
                                                <th width="15%"><?php echo e(__('Status')); ?></th>
                                                <th width="15%"><?php echo e(__('Action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($loop->index + 1); ?></td>
                                                    <td>
                                                        <?php echo e($comment->comment); ?>

                                                    </td>
                                                    <td><?php echo e($comment?->post?->title); ?></td>

                                                    <td>
                                                        <?php echo e($comment->user->name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($comment->user->email); ?>

                                                    </td>

                                                    <td>
                                                        <input onchange="changeStatus(<?php echo e($comment->id); ?>)"
                                                            id="status_toggle" type="checkbox"
                                                            <?php echo e($comment->status ? 'checked' : ''); ?> data-toggle="toggle"
                                                            data-on="<?php echo e(__('Active')); ?>" data-off="<?php echo e(__('Inactive')); ?>"
                                                            data-onstyle="success" data-offstyle="danger">
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(route('admin.blog-comment.show', $comment?->post?->id)); ?>"
                                                            class="btn btn-success btn-sm"><i class="fa fa-eye"
                                                                aria-hidden="true"></i></a>
                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                            onclick="deleteData(<?php echo e($comment->id); ?>)"><i
                                                                class="fa fa-trash" aria-hidden="true"></i></a>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Post Comments'),'route' => 'admin.blog-comment.index','create' => 'no','message' => __('No data found!'),'colspan' => '7'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="float-right">
                                    <?php echo e($comments->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id) {
            $("#deleteForm").attr("action", '<?php echo e(url('/admin/blog-comment/')); ?>' + "/" + id)
        }

        function changeStatus(id) {
            var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>"
            if (isDemo == 0) {
                toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                return;
            }
            $.ajax({
                type: "put",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                url: "<?php echo e(url('/admin/blog-comment/status-update')); ?>" + "/" + id,
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.warning(response.message);
                    }
                },
                error: function(xhr, status, err) {
                    console.log(err);
                    let errors = xhr.responseJSON.errors;
                    $.each(errors, function (key, value) {
                        toastr.error(value);
                    })

                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .dd-custom-css {
            position: absolute;
            will-change: transform;
            top: 0px;
            left: 0px;
            transform: translate3d(0px, -131px, 0px);
        }

        .max-h-400 {
            min-height: 400px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Blog\resources\views\Comment\index.blade.php ENDPATH**/ ?>