<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Level List')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Course Level')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.course-level.index')); ?>"><?php echo e(__('Course Level List')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Level')); ?></div>
                </div>
            </div>

            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>
                            <hr>
                            <?php if($code !== $languages->first()->code): ?>
                                <button class="btn btn-primary" id="translate-btn"><?php echo e(__('Translate')); ?></button>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.course-level.edit', ['course_level' => $courseLevel->id, 'code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Level')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.course-level.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form
                                    action="<?php echo e(route('admin.course-level.update', ['course_level' => $courseLevel->id, 'code' => $code])); ?>"
                                    method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-md-8 offset-md-2">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('Name')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="name" name="name"
                                                    value="<?php echo e(old('name', $courseLevel->getTranslation($code)->name)); ?>"
                                                    placeholder="<?php echo e(__('Enter name')); ?>" class="form-control">
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div
                                            class="col-md-8 offset-md-2 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                            <div class="form-group">
                                                <label for="status"><?php echo e(__('Status')); ?><span
                                                        class="text-danger">*</span></label>
                                                <select class="form-control" name="status">
                                                    <option <?php if($courseLevel->status == 1): echo 'selected'; endif; ?> value="1"><?php echo e(__('Active')); ?>

                                                    </option>
                                                    <option <?php if($courseLevel->status == 0): echo 'selected'; endif; ?> value="0">
                                                        <?php echo e(__('Inactive')); ?></option>
                                                </select>
                                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="text-center offset-md-2 col-md-8">
                                            <?php if (isset($component)) { $__componentOriginal42eb0eb0445477e4b420137b90787aa6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42eb0eb0445477e4b420137b90787aa6 = $attributes; } ?>
<?php $component = App\View\Components\Admin\SaveButton::resolve(['text' => __('Save')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\SaveButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $attributes = $__attributesOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $component = $__componentOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__componentOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(function() {
            const $name = $("#name"),
                $slug = $("#slug");

            $name.on("keyup", function(e) {
                $slug.val(convertToSlug($name.val()));
            });

            function convertToSlug(text) {
                return text
                    .toLowerCase()
                    .replace(/[^a-z\s-]/g, "") // Remove all non-word characters (except -)
                    .replace(/\s+/g, "-") // Replace spaces with -
                    .replace(/-+/g, "-"); // Replace multiple - with single -
            }

            $('#translate-btn').on('click', function() {
                translateAllTo("<?php echo e($code); ?>");
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course-level\edit.blade.php ENDPATH**/ ?>